/* upshotxsum.c */

#include "xsum.h"


/*****************************************************************************/
/*			VARIABLES DECLARED IN XSUM.C                         */
/*****************************************************************************/
extern int num_procs, num_states;
extern timevar total_time;
extern char logfilename[80], statefilename[80];
extern struct statetype state[MAXNUMSTATES];
extern struct sum procinfo[MAXNUMPROCS][MAXNUMSTATES];


/*****************************************************************************/
/* INPUTDATA:  reads the log file and the state file.  Initializes the       */
/*	       global variables declared above.                              */
/*****************************************************************************/
void InputData(argc,argv)
int argc;
char *argv[];
{
    FILE *logfile, *statefile;
    int event_type,proc_id,int_data,i,j,valid,done;
    long end_of_controls;
    timevar timestamp,starttime,endtime;
    char line[100];

    if(argc != 3){
	printf("usage: xsum <log file> <state file>\n");
	exit(1);
	}
	
    if((logfile = fopen(argv[1],"r")) == NULL){
	printf("can't open logfile %s\n",argv[1]);
	exit(1);
	}

    if((statefile = fopen(argv[2],"r")) == NULL){
	printf("can't open statefile %s\n",argv[2]);
	exit(1);
	}

    strcpy(logfilename,argv[1]);
    strcpy(statefilename,argv[2]);

    /* Read the statefile */

    num_states = 0;
    while(fgets(line,sizeof(line),statefile) != NULL){
  	if(num_states >= MAXNUMSTATES)  break;  /* safety mechanism */
	
	sscanf(line,"%d %d %d %s %s",&state[num_states].state_num,
		&state[num_states].entry,&state[num_states].exit,
		state[num_states].color,state[num_states].note);
	++num_states;
	}

    fclose(statefile);

    /* Read the logfile */

    /* Get the number of processes from the control statements */
    done = FALSE;
    while((fgets(line,sizeof(line),logfile) != NULL) && (!done)){
	if(sscanf(line,"%d %d %*d %d %*d %ul",
			&event_type,&proc_id,&int_data,&timestamp) == 4)
	    ;
	else if(sscanf(line,"%d %d %*d %d %*d %ul %*s",
			&event_type,&proc_id,&int_data,&timestamp) == 4)
	    ;
	/* else printf("invalid : %s\n",line); */

	if(event_type >= 0)	/* Have ended the control statements */
	    done = TRUE;

	switch(event_type){
	    case -3:
		num_procs = int_data;
		break;
	    case -6:
		starttime = timestamp;
		break;
	    case -7:
		endtime = timestamp;
		break;
	    }

	if(!done)
	    end_of_controls = ftell(logfile);


	}  /* End of while loop */

    total_time = endtime - starttime;

    /* rewind the file one line; reread the first non-control line */
    if(fseek(logfile,end_of_controls,0) != 0){
	printf("File I/O error.\n");
	exit(1);
	}

    /* initialize procinfo */
    for(i=0;i<num_procs;++i)
	for(j=0;j<num_states;++j)
	    procinfo[i][j].total_time = 0;

    i = 0; /* total number of valid events */
    while(fgets(line,sizeof(line),logfile) != NULL){

	if(sscanf(line,"%d %d %*d %*d %*d %d",
		&event_type,&proc_id,&timestamp) == 3)
	    ;
	else if(sscanf(line,"%d %d %*d %*d %*d %d %*s",
		&event_type,&proc_id,&timestamp) == 3)
	    ;
	/* else printf("invalid : %s\n",line);*/

	valid = FALSE;

	for(j=0;j<num_states;++j){
	    if(state[j].entry == event_type){
		procinfo[proc_id][j].state_num = state[j].state_num;
		procinfo[proc_id][j].entry_time = timestamp;
		valid = TRUE;
		break;
		}
	    else if(state[j].exit == event_type){
		procinfo[proc_id][j].total_time += 
			(timestamp - procinfo[proc_id][j].entry_time);
		valid = TRUE;
		break;
		}
	    }

	if(valid) ++i;

	}  /* End of while loop to read in the events */

    fclose(logfile);

    compute_percentage();

   /*
    for(i=0; i<num_procs; ++i)
	for(j=0; j<num_states; ++j)
	    printf("  proc...%d state...%d total...%u\n",
			i,procinfo[i][j].state_num,procinfo[i][j].total_time);*/

}  /* End of Function InputData */ 


/*****************************************************************************/
/* COMPUTE_PERCENTAGE:  for each process and each state, the amount of time  */
/*			spent by a process for a state divided by the total  */
/*			time is computed.                                    */
/*****************************************************************************/
compute_percentage()
{
    int i,j;

    for(i=0;i<num_procs;++i)
	for(j=0;j<num_states;++j)
	    procinfo[i][j].percent = 
		((float)procinfo[i][j].total_time/(float)total_time)*100.0;
}

/* end */
