#include "xedge.h"

Widget toplevel,form,finescrollbar,scrollbar,scrollcount,scrollunits,
       magnifylabel,canvas,buttonform,magnifybutton,unmagnifybutton,nextevent,
       autoscroll,reset,quit;

struct event *buffer;
struct procinfo *proc;
struct statetype state[MAXNUMSTATES];
int num_procs,num_states;
long unsigned num_legal_events;
timevar interval;

int curr_state;  /* Variable used in MainLoop function to tell     */
                 /* whether to continue autoscrolling or do something else. */
int track;

Display *dpy;
Window win;
Colormap cmap;
GC gc,gcred,gcLightGray,gcwhite,gcblack;
Pixmap *procbox;
long foreground,background;
int screen;
int frame_depth;
int have_color;
int cellwidth,cellheight,gridsize;

timevar t0,tfinal;
timevar curr_time;
timevar prev_time;
timevar total_time;

double dbl_curr_time;
double dbl_prev_time;
double magnification;

char buf[50];
double conv_factor;
char units[15];
double fine_prev,fine_curr;

int first_resize;
int canvas_height,canvas_width;

void main(argc,argv)
int argc;
char *argv[];
{

    InputData(argc,argv);
    InitGraphics(argc,argv);

    MainLoop();

}  /* End of Function Main */

void MainLoop()
{
    XEvent event;
    Arg args[2];
    int n;
    int num_of_intervals;
    double pct,finepct;
    register int i;

    while(1){

	switch(curr_state){
	    case STOPPED : /* Do nothing */
		           break;
	    case RUNNING : prev_time = curr_time;
			   curr_time += 1000/magnification;
			   if(curr_time > total_time){
			       curr_time = total_time;
			       curr_state = STOPPED;
			       }  /* End if */
/*
			   for(i=0;i<1000/magnification;i++){
			       curr_time++;
			       if(curr_time>total_time){
				   curr_state = STOPPED;
				   curr_time--;
				   break;
			           }  cc End if cc
			       }  cc End of "for" loop cc
			   printf("calling DrawNextTimeStep, curr_time=%lu, prev_time=%lu\n",curr_time,prev_time);
*/
			   DrawNextTimeStep(curr_time,prev_time);

			   /* Update */

			   n = 0;
			   sprintf(buf,"%8.2lf",(double)curr_time/conv_factor);
			   XtSetArg(args[n],XtNlabel,buf);n++;
			   XtSetValues(scrollcount,args,n);
			       
			   /* Update the scrollbars */
			       
			   pct = (double)curr_time/
			       (double)total_time;
			       
			   if(curr_time == 0)
			       num_of_intervals = 0;
			   else
			       num_of_intervals = ceil((double)
					(total_time*pct)/interval) - 1;

			   finepct = (double)curr_time/interval -
			       num_of_intervals;
			   
			   if(curr_time == total_time)
			       finepct = 1.0;
			   
			   XawScrollbarSetThumb(scrollbar,pct,-1.0);
			   XawScrollbarSetThumb(finescrollbar,finepct,-1.0);

			   XFlush(dpy);

			   break;

            }  /* End of switch */

	while(XtPending()){
	    XtNextEvent(&event);
	    XtDispatchEvent(&event);
	    }

        }  /* End of infinite "while" loop */

}  /* End of Function MainLoop */

void InitGraphics(argc,argv)
int argc;
char *argv[];
{
    Arg args[25];
    int n;
    int i;
    XSetWindowAttributes w_attr;

    /* Initial Conditons */

    curr_time = 0;   /* Set current time to 0 */
    prev_time = 0;   /* Set previous time to 0 */
    dbl_curr_time = 0.0;
    dbl_prev_time = 0.0;
    magnification = 1.0;
    interval = total_time;
    first_resize = 1;      /* true */
    canvas_height = canvas_width = CANVAS_SIZE;
    curr_state = STOPPED;
    fine_prev = fine_curr = 0.0;

    toplevel = XtInitialize(argv[0],"xedge",NULL,0,&argc,argv);

    dpy = XtDisplay(toplevel);
    screen = DefaultScreen(dpy);
    cmap = DefaultColormap(dpy,screen);

    frame_depth = XDefaultDepth(dpy,screen);

    have_color = (frame_depth > 1 ? 1 : 0);

    /* set up colors */
    
    if (have_color)
    {
	foreground = ConvertColor(canvas,"red");
	background = ConvertColor(canvas,"LightGray");
    }
    else
    {
	foreground = ConvertColor(canvas,"black");
	background = ConvertColor(canvas,"white");
    }

    /* the containg form */
    
    form = XtCreateManagedWidget("form",formWidgetClass,toplevel,NULL,0);

    /* the scrollbar */

    n = 0;
    XtSetArg(args[n],XtNorientation,XtorientHorizontal);n++;
    XtSetArg(args[n],XtNlength,500);n++;
    XtSetArg(args[n],XtNthickness,15);n++;
    scrollbar = XtCreateManagedWidget("scrollbar",scrollbarWidgetClass,
				      form,args,n);
    XtAddCallback(scrollbar,XtNjumpProc,ScrollJump,NULL);

    XawScrollbarSetThumb(scrollbar,0.0,0.01);

    /* the finescrollbar */

    n = 0;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,scrollbar);n++;
    XtSetArg(args[n],XtNorientation,XtorientHorizontal);n++;
    XtSetArg(args[n],XtNlength,500);n++;
    XtSetArg(args[n],XtNthickness,15);n++;
    finescrollbar = XtCreateManagedWidget("finescrollbar",scrollbarWidgetClass,
					  form,args,n);
    XtAddCallback(finescrollbar,XtNjumpProc,FineScrollJump,NULL);

    XawScrollbarSetThumb(finescrollbar,0.0,0.01);

    /* the counter for the scrollbar */
    
    n = 0;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,finescrollbar);n++;
    sprintf(buf,"%8.2lf",dbl_curr_time/conv_factor);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNwidth,150);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    scrollcount = XtCreateManagedWidget("scrollcount",labelWidgetClass,
					form,args,n);

    /* the label for the units */
    
    n = 0;
    XtSetArg(args[n],XtNhorizDistance,10);n++;
    XtSetArg(args[n],XtNfromHoriz,scrollcount);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,finescrollbar);n++;
    sprintf(buf,"%s",units);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    scrollunits = XtCreateManagedWidget("scrollcount",labelWidgetClass,
					form,args,n);

    /* the label for the amount of magnification */
    
    n = 0;
    XtSetArg(args[n],XtNhorizDistance,20);n++;
    XtSetArg(args[n],XtNfromHoriz,scrollunits);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNfromVert,finescrollbar);n++;
    sprintf(buf,"Magnified %6.3lf times",magnification);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetArg(args[n],XtNheight,15);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    magnifylabel = XtCreateManagedWidget("magnifylabel",labelWidgetClass,
					 form,args,n);

    /* the canvas */

    n = 0;
    XtSetArg(args[n],XtNfromVert,scrollcount);n++;
    XtSetArg(args[n],XtNvertDistance,10);n++;
    XtSetArg(args[n],XtNheight,CANVAS_SIZE); n++;
    XtSetArg(args[n],XtNwidth,CANVAS_SIZE); n++;
    XtSetArg(args[n],XtNborderWidth,1); n++;
    XtSetArg(args[n],XtNforeground,foreground); n++;
    XtSetArg(args[n],XtNbackground,background); n++;
    canvas = XtCreateManagedWidget("canvas",compositeWidgetClass,
                                    form,args,n);

    /* the buttons form */

    n = 0;
    XtSetArg(args[n],XtNhorizDistance,25);n++;
    XtSetArg(args[n],XtNfromHoriz,canvas);n++;
    XtSetArg(args[n],XtNvertDistance,200);n++;
    XtSetArg(args[n],XtNfromVert,finescrollbar);n++;
    XtSetArg(args[n],XtNborderWidth,0);n++;
    buttonform = XtCreateManagedWidget("buttonform",formWidgetClass,
				       form,args,n);

    /* the magnification button */

    n = 0;
    XtSetArg(args[n],XtNheight,30);n++;
    XtSetArg(args[n],XtNwidth,120);n++;
    XtSetArg(args[n],XtNlabel,"Magnify");n++;
    magnifybutton = XtCreateManagedWidget("magnifybutton",commandWidgetClass,
					  buttonform,args,n);
    XtAddCallback(magnifybutton,XtNcallback,Magnify,0);


    /* the unmagnification button */

    n = 0;
    XtSetArg(args[n],XtNfromVert,magnifybutton);n++;
    XtSetArg(args[n],XtNvertDistance,20);n++;
    XtSetArg(args[n],XtNheight,30);n++;
    XtSetArg(args[n],XtNwidth,120);n++;
    XtSetArg(args[n],XtNlabel,"UnMagnify");n++;
    unmagnifybutton = XtCreateManagedWidget("unmagnifybutton",
					    commandWidgetClass,buttonform,
					    args,n);
    XtAddCallback(unmagnifybutton,XtNcallback,UnMagnify,0);

    /* the next event button */

    n = 0;
    XtSetArg(args[n],XtNfromVert,unmagnifybutton);n++;
    XtSetArg(args[n],XtNvertDistance,20);n++;
    XtSetArg(args[n],XtNheight,30);n++;
    XtSetArg(args[n],XtNwidth,120);n++;
    XtSetArg(args[n],XtNlabel,"Next Event");n++;
    nextevent = XtCreateManagedWidget("nextevent",
				      commandWidgetClass,buttonform,args,n);
    XtAddCallback(nextevent,XtNcallback,NextEvent,0);

    /* the autoscroll button */

    n = 0;
    XtSetArg(args[n],XtNfromVert,nextevent);n++;
    XtSetArg(args[n],XtNvertDistance,20);n++;
    XtSetArg(args[n],XtNheight,30);n++;
    XtSetArg(args[n],XtNwidth,120);n++;
    XtSetArg(args[n],XtNlabel,"Auto-Scroll");n++;
    autoscroll = XtCreateManagedWidget("autoscroll",commandWidgetClass,
				       buttonform,args,n);
    XtAddCallback(autoscroll,XtNcallback,AutoScroll,0);

    /* the reset button */

    n = 0;
    XtSetArg(args[n],XtNfromVert,autoscroll);n++;
    XtSetArg(args[n],XtNvertDistance,20);n++;
    XtSetArg(args[n],XtNheight,30);n++;
    XtSetArg(args[n],XtNwidth,120);n++;
    XtSetArg(args[n],XtNlabel,"Reset");n++;
    reset = XtCreateManagedWidget("reset",commandWidgetClass,buttonform,
				  args,n);
    XtAddCallback(reset,XtNcallback,Reset,0);

    /* the quit button */
    
    n = 0;
    XtSetArg(args[n],XtNfromVert,reset);n++;
    XtSetArg(args[n],XtNvertDistance,20);n++;
    XtSetArg(args[n],XtNheight,30);n++;
    XtSetArg(args[n],XtNwidth,120);n++;
    XtSetArg(args[n],XtNlabel,"Quit");n++;
    quit = XtCreateManagedWidget("quit",commandWidgetClass,buttonform,args,n);
    XtAddCallback(quit,XtNcallback,Quit,0);

    XtAddEventHandler(canvas,StructureNotifyMask,FALSE,resize_jobs,NULL);

    XtRealizeWidget(toplevel);

    win = XtWindow(canvas);
    dpy = XtDisplay(canvas);

    if(have_color){
	gc = XCreateGC(dpy,win,NULL,NULL);
	gcred = XCreateGC(dpy,win,NULL,NULL);
	gcLightGray = XCreateGC(dpy,win,NULL,NULL);
	gcblack = XCreateGC(dpy,win,NULL,NULL);

	XSetForeground(dpy,gcred,ConvertColor(canvas,"red"));
	XSetForeground(dpy,gcLightGray,ConvertColor(canvas,"LightGray"));
	XSetForeground(dpy,gcblack,ConvertColor(canvas,"black"));
        }
    else{
	gc = XCreateGC(dpy,win,NULL,NULL);
	gcwhite = XCreateGC(dpy,win,NULL,NULL);
	gcblack = XCreateGC(dpy,win,NULL,NULL);

	XSetForeground(dpy,gcwhite,ConvertColor(canvas,"white"));
	XSetForeground(dpy,gcblack,ConvertColor(canvas,"black"));
        }

    /* Create the array of pixmaps */

    procbox = (Pixmap *)malloc(sizeof(Pixmap)*(num_states+2));

    for(i=0;i<(num_states+2);i++){

	procbox[i] = XCreatePixmap(dpy,win,cellwidth-1,cellheight-1,
				   frame_depth);
	if(i==0)
	    XSetForeground(dpy,gc,ConvertColor(canvas,"black"));
	else if(i==1)
	    XSetForeground(dpy,gc,ConvertColor(canvas,"white"));
	else{
	    if(have_color)
		XSetForeground(dpy,gc,ConvertColor(canvas,state[i-2].color));
	    else
		XSetForeground(dpy,gc,ConvertColor(canvas,"black"));
	    }  /* End else */
	XFillRectangle(dpy,procbox[i],gc,0,0,cellwidth,cellheight);
        }

    /* Additions so that the picture is saved when the window is changed */

    w_attr.backing_store = Always;   /* retain window contents */
    w_attr.save_under = True;	 /* save invisible part of canvas */

    XChangeWindowAttributes(dpy,win,(CWBackingStore | CWSaveUnder),&w_attr);

    Reset(canvas,NULL,NULL);

}  /* End of Function InitGraphics */

void Quit(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    
    exit(0);
    
}  /* End of Function Quit */

void resize_jobs(w,data,event,continue_to_dispatch)
Widget w;
caddr_t data;
XEvent *event;
Boolean *continue_to_dispatch;
{
    int newwidth,newheight;
    int newcellwidth,newcellheight;
    int i,j;

    /* First resize event is received when the program first starts up.  We */
    /* don't want to deal with the events quite yet at this point. */

    if(first_resize)

	first_resize = 0;

    else{

	newwidth = event->xconfigure.width;
	newheight = event->xconfigure.height;

	canvas_width = newwidth;
	canvas_height = newheight;
	
	newcellwidth = newwidth/gridsize;
	newcellheight = newheight/gridsize;

	cellwidth = newcellwidth;
	cellheight = newcellheight;

	/* Clear the screen */

	XSetForeground(dpy,gc,background);
	XSetFunction(dpy,gc,GXcopy);
	XFillRectangle(dpy,win,gc,0,0,canvas_width,canvas_height);
	XSetForeground(dpy,gc,foreground);

	/* Recompute the sizes of the boxes for the processors and assign */
        /* the value to the correct members of the array of structures */
	
	for(i=0;i<gridsize;i++){         /* the y-coordinate */
	    for(j=0;j<gridsize;j++){        /* the x-coordinate */
		proc[i*gridsize+j].x0 = j*newcellwidth;
		proc[i*gridsize+j].y0 = i*newcellheight;
		proc[i*gridsize+j].x1 = (j+1)*newcellwidth - 1;
		proc[i*gridsize+j].y1 = (i+1)*newcellheight - 1;
                }  /* End of inner "for" */

            }   /* End of outer "for" */

	/* Free the old pixmaps */

	for(i=0;i<(num_states+2);i++){
	    XFreePixmap(dpy,procbox[i]);
	    }  /* End for */

	/* Re-Initialize the array of pixmaps */

	for(i=0;i<(num_states+2);i++){
	    procbox[i] = XCreatePixmap(dpy,win,newcellwidth-1,newcellheight-1,
				       frame_depth);
	    if(i==0)
		XSetForeground(dpy,gc,ConvertColor(canvas,"black"));
	    else if(i==1)
		XSetForeground(dpy,gc,ConvertColor(canvas,"white"));
	    else{
		if(have_color)
		    XSetForeground(dpy,gc,
				   ConvertColor(canvas,state[i-2].color));
		else
		    XSetForeground(dpy,gc,ConvertColor(canvas,"black"));
	        }  /* End else */
	    XFillRectangle(dpy,procbox[i],gc,0,0,newcellwidth,newcellheight);
            }  /* End for */

	/* Redraw the processors */

	for(i=0;i<num_procs;i++)
	    XCopyArea(dpy,procbox[proc[i].color],win,gc,0,0,cellwidth,
		      cellheight,proc[i].x0,proc[i].y0);

        }  /* End else */

}  /* End of Function resize_jobs */

void FineScrollJump(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    float pct = *((float *) call_data);
    Arg args[5];
    int n;
    int num_of_intervals;
    double timemin,timemax,timeinterval;
    double dbl_curr_time;
    float totalpct;
    boolean skip;

    if(curr_state==RUNNING)
	curr_state = STOPPED;

    /* Calculation and assignment to indicate whether to scroll continuously */
    /* or jump discretely. */

    fine_prev = fine_curr;
    fine_curr = pct;
    if( fabs(fine_curr-fine_prev) > 0.01 )
        skip = TRUE;
    else
	skip = FALSE;

    /* get the position of the total scrollbar */
    
    n = 0;
    XtSetArg(args[n],XtNtopOfThumb,&totalpct);n++;
    XtGetValues(scrollbar,args,n);

    /* Determine the number of intervals.  An unfortunate special case was */
    /* necessary so that num_of_intervals would never be zero */
    
    if(curr_time == 0)
	num_of_intervals = 0;
    else
	num_of_intervals = ceil((double)(total_time*totalpct)/interval) - 1;

    /* Reset prev_time */

    prev_time = curr_time;

    dbl_curr_time = (num_of_intervals + pct)*interval;

    curr_time = (timevar) dbl_curr_time;

    /* update the time counter */

    n = 0;
    sprintf(buf,"%8.2lf",dbl_curr_time/conv_factor);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(scrollcount,args,n);

    /* Reset the total scrollbar */

    totalpct = (float) dbl_curr_time/total_time;

    XawScrollbarSetThumb(scrollbar,totalpct,-1.0);

    ReDraw(skip);

}  /* End of Function FineScrollJump */

/* Function ScrollJump

   This function is the scrolljump callback routine.  It is called when
   NotifyThumb is sensed on the scrollbar Widget. */

void ScrollJump(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{

    float pct = *((float *) call_data);
    Arg args[2];
    int n;
    int num_of_intervals;
    double dbl_curr_time;
    double finepct;
    boolean skip;

    if(curr_state==RUNNING)
	curr_state = STOPPED;

    /* Reset prev_time */

    prev_time = curr_time;

    dbl_curr_time = pct*(tfinal-t0);  /* Reset current time */

    curr_time = (timevar) dbl_curr_time;

    /* Test to see if we need to scroll through all events of if we just */
    /* want to jump to a new event. */

    if( ((double)curr_time - (double)prev_time)/(double)total_time > 0.01 )
	skip = TRUE;
    else
	skip = FALSE;

    /* update the time counter */

    n = 0;
    sprintf(buf,"%8.2lf",dbl_curr_time/conv_factor);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(scrollcount,args,n);

    XFlush(dpy);

    /* Update the fine scrollbar */

    if(curr_time == 0)
	num_of_intervals = 0;
    else
	num_of_intervals = ceil((double)(total_time*pct)/interval) - 1;

    finepct = dbl_curr_time/interval - num_of_intervals;

    /* makes the fine button stay on the right when the total button is */
    /* all the way to the right */
    
    if(curr_time == total_time)
	finepct = 1.0;

    XawScrollbarSetThumb(finescrollbar,finepct,-1);

    ReDraw(skip);
    
}  /* End of Function ScrollJump */

void AutoScroll(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    int i;
    
    if(curr_state==STOPPED)
	curr_state = RUNNING;
    else
	curr_state = STOPPED;

    track = 0;

    /* Get tracker to the next event. */
    
    while(buffer[track].relative_time <= curr_time)
	track++;

}  /* End of Function AutoScroll */

void DrawNextTimeStep(t_curr,t_prev)
timevar t_curr;
timevar t_prev;
{
    register timevar t;
    int process_number,x,y,width,height;
    register int spin;

    for(t=t_prev;t<=t_curr;t++){
	
	while(buffer[track].relative_time == t){
	    process_number = buffer[track].id;
	    x = proc[process_number].x0;
	    y = proc[process_number].y0;
	    width = proc[process_number].x1 - proc[process_number].x0;
	    height = proc[process_number].y1 - proc[process_number].y0;

	    /* New state is entered */
	    
	    if(buffer[track].status == 1){

		if(have_color)
		    proc[process_number].color = buffer[track].event;
		else
		    proc[process_number].color = 0;  /* black */

	        }  /* End if */

	    /* Old state was exited */

	    else{

		if(have_color)
		    proc[process_number].color = 0;  /* black */
		else
		    proc[process_number].color = 1;  /* white */

	        } /* End else */

	    XCopyArea(dpy,procbox[proc[process_number].color],win,
		      gc,0,0,width,height,x,y);
		
	    track++;  /* If found move to the next event in the buffer */

	    XFlush(dpy); /* Assure that each color change is drawn */	    

	    }  /* end of "while" loop */

	/* Spin for a while */

	for(spin=0;spin<10*magnification;spin++)
	    ;
		
        }  /* End of "for" loop */

}  /* End of Function DrawNextTimeStep */

void Magnify(w,call_data,client_data)
Widget w;
caddr_t call_data;
caddr_t client_data;
{
    Arg args[2];
    int n;

    magnification *= 2;  /* Magnify by two */

    interval /= 2;    /* Divide interval by two */

    n = 0;
    sprintf(buf,"Magnified %6.3lf times",magnification);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(magnifylabel,args,n);

    /* Adjust the length of the button on the fine scrollbar */

    XawScrollbarSetThumb(finescrollbar,-1.0,magnification*0.01);

}  /* End of Function Magnify */

void UnMagnify(w,call_data,client_data)
Widget w;
caddr_t call_data;
caddr_t client_data;
{
    Arg args[2];
    int n;

    magnification /= 2;  /* Unmagnify by two */

    interval *= 2;    /* Multiply interval by two */

    n = 0;
    sprintf(buf,"Magnified %6.3lf times",magnification);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(magnifylabel,args,n);

    /* Adjust the length of the button on the fine scrollbar */

    XawScrollbarSetThumb(finescrollbar,-1.0,magnification*0.01);

}  /* End of Function UnMagnify */

void NextEvent(w,call_data,client_data)
Widget w;
caddr_t call_data;
caddr_t client_data;
{
    Arg args[2];      /* ARGS : array of arguments used to reset the time */
                      /*        counter, and the two scrollbars. */
    int n;            /* N : keeps track of the number of elements in ARGS. */
    timevar timer;    /* TIMER : time variable which will hold the value of */
                      /*         the current time being searched. */
    int tracker;      /* TRACKER : an index variable used to find the */
                      /*           position of the last drawn event. */
    int num_of_intervals;
    float scrollpct,finepct;
    int process_number,x,y,height,width;

    if(curr_state == RUNNING)
	curr_state = STOPPED;

    /* Reset the tracker. */
    
    tracker = 0;

    /* Get tracker to the next event. */
    
    while(buffer[tracker].relative_time <= curr_time)
	tracker++;

    /* Check to make sure that there is another event. */

    if(tracker >= num_legal_events){
	printf("ERROR : no more events!\n");
	return;
        }  /* Endif */

    /* Draw the next event */

    process_number = buffer[tracker].id;
    x = proc[process_number].x0;
    y = proc[process_number].y0;
    width = proc[process_number].x1 - proc[process_number].x0;
    height = proc[process_number].y1 - proc[process_number].y0;

    /* process color should be set to running */

    if(buffer[tracker].status == 1){

	if(have_color)
	    proc[process_number].color = buffer[tracker].event;
	else
	    proc[process_number].color = 0;  /* set to black */

        } /* End if */

    /* process color should be set to idle */

    else{      

	if(have_color)
	    proc[process_number].color = 0;  /* set to black */
	else
	    proc[process_number].color = 1;  /* set to white */

        } /* End else */

    XCopyArea(dpy,procbox[proc[process_number].color],win,gc,0,0,width,height,
	      x,y);

    /* Reset curr_time and prev_time */

    prev_time = curr_time;
    curr_time = buffer[tracker].relative_time;

    /* Update the scrollcounter, and scrollbars */
    
    n = 0;
    sprintf(buf,"%8.2lf",(double) curr_time/conv_factor);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(scrollcount,args,n);	    

    /* Reset the thumb on the scrollbar */

    scrollpct = (double) curr_time / (double) total_time;
    XawScrollbarSetThumb(scrollbar,(float) scrollpct,-1.0);

    /* Reset the thumb on the fine scrollbar */

    if(curr_time == 0)
	num_of_intervals = 0;
    else
	num_of_intervals = ceil((double)(total_time*scrollpct)/interval) - 1;

    finepct = (double) curr_time/interval - num_of_intervals;
    XawScrollbarSetThumb(finescrollbar,(float) finepct,-1.0);
    
}  /* End of Function NextEvent */

void Reset(w,call_data,client_data)
Widget w;
caddr_t call_data;
caddr_t client_data;
{
    int i;
    Arg args[2];
    int n;

    if(curr_state == RUNNING)
	curr_state = STOPPED;

    /* Clear the screen */

    XSetForeground(dpy,gc,background);
    XSetFunction(dpy,gc,GXcopy);
    XFillRectangle(dpy,win,gc,0,0,canvas_width,canvas_height);
    XSetForeground(dpy,gc,foreground);
    
    /* Perform initial drawing */

    for(i=0;i<num_procs;i++){
	if(have_color)           /* Draw black */
	    XCopyArea(dpy,procbox[0],win,gc,0,0,cellwidth,cellheight,
		      proc[i].x0,proc[i].y0);
	else                     /* Draw white */
	    XCopyArea(dpy,procbox[1],win,gc,0,0,cellwidth,cellheight,
		      proc[i].x0,proc[i].y0);
        }  /* End of "for" loop */

    /* Reset the thumb on the scrollbar */

    XawScrollbarSetThumb(scrollbar,0.0,-1);

    /* Reset the thumb on the fine scrollbar */

    XawScrollbarSetThumb(finescrollbar,0.0,-1);

    /* Reset curr_time and prev_time */
    
    curr_time = prev_time = 0;

    /* Update the scrollcounter */
    
    n = 0;
    sprintf(buf,"%8.2lf",0.0);
    XtSetArg(args[n],XtNlabel,buf);n++;
    XtSetValues(scrollcount,args,n);

    XFlush(dpy);

}  /* End of Function Reset */

void ReDraw(skip)
boolean skip;
{
    int tracker;
    int process_number,x,y,height,width;
    int i;

    tracker = 0;

    if(curr_time > prev_time){

	while(buffer[tracker].relative_time < prev_time)
	    tracker++;

	while((buffer[tracker].relative_time <= curr_time)&&
	      (tracker<num_legal_events)){
	    process_number = buffer[tracker].id;
	    x = proc[process_number].x0;
	    y = proc[process_number].y0;
	    width = proc[process_number].x1 - proc[process_number].x0;
	    height = proc[process_number].y1 - proc[process_number].y0;

	    /* process color should be set to running */

	    if(buffer[tracker].status == 1){

		if(have_color)
		    proc[process_number].color = buffer[tracker].event;
		else
		    proc[process_number].color = 0;  /* set to black */

	        } /* End if */

	    /* process color should be set to idle */

	    else{      

		if(have_color)
		    proc[process_number].color = 0;  /* set to black */
		else
		    proc[process_number].color = 1;  /* set to white */

	        } /* End else */

	    if(!skip)
		XCopyArea(dpy,procbox[proc[process_number].color],
			  win,gc,0,0,width,height,x,y);
		
	    tracker++;  /* Increment tracker */

            }  /* end of "while" loop */
		
        }  /* End if */

    else{   /* prev_time >= curr_time */

	while(buffer[tracker].relative_time < prev_time)
	    tracker++;

	tracker++;

	while((buffer[tracker].relative_time >= curr_time)&&(tracker >= 0)){
	    process_number = buffer[tracker].id;
	    x = proc[process_number].x0;
	    y = proc[process_number].y0;
	    width = proc[process_number].x1 - proc[process_number].x0;
	    height = proc[process_number].y1 - proc[process_number].y0;

	    /* Color of process should be set to idle */

	    if(buffer[tracker].status == 1){

		if(have_color)
		    proc[process_number].color = 0;  /* set to black */
		else
		    proc[process_number].color = 1;  /* set to white */

	        } /* End if */

	    /* Color should be set to active */

	    else{

		if(have_color)
		    proc[process_number].color = buffer[tracker].event;
		else
		    proc[process_number].color = 0;  /* set to black */

	        } /* End else */

	    if(!skip)
		XCopyArea(dpy,procbox[proc[process_number].color],
			  win,gc,0,0,width,height,x,y);
		
	    tracker--;  /* Decrement tracker */

            }  /* end of "while" loop */

        }  /* End else */

    if(skip){   /* Then simply redraw the last state */

	for(i=0;i<num_procs;i++){
	    if(have_color)           /* Draw black */
		XCopyArea(dpy,procbox[proc[i].color],win,gc,0,0,
			  cellwidth,cellheight,proc[i].x0,proc[i].y0);
	    else                     /* Draw white */
		XCopyArea(dpy,procbox[proc[i].color],win,gc,0,0,
			  cellwidth,cellheight,proc[i].x0,proc[i].y0);
            }  /* End of "for" loop */

        }  /* End if */

}  /* End of Function ReDraw */

int ConvertColor(w,colorname)
Widget w;
char *colorname;
{
    XColor color,ignore;

    if(XAllocNamedColor(dpy,cmap,colorname,&color,&ignore))
	return (color.pixel);
    else{
	printf("Warning: couldn't allocate color %s\n",colorname);
	return (BlackPixel(dpy, screen));
        }
    
}  /* End of Function ConvertColor */
