#include "stdio.h"
#include "math.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Command.h>

#define CANVAS_SIZE   500
#define MAXSTRLEN      20
#define MAXNUMSTATES   50
#define STOPPED         0
#define RUNNING         1
#define TRUE            1
#define FALSE           0

typedef unsigned long timevar;
typedef short boolean;

struct event{
    int event;
    int id;
    int status;            /* if true, state is just starting, if false, the */
                           /* state is just ending */
    timevar relative_time;
};

struct procinfo{
    int x0,y0;
    int x1,y1;
    int color;
};

struct statetype{
    int state_num;
    int entry;
    int exit;
    char color[MAXSTRLEN];
};

void MainLoop();
void InputData();
void InitGraphics();
void Quit();
void resize_jobs();
void FineScrollJump();
void ScrollJump();
void Magnify();
void UnMagnify();
void NextEvent();
void AutoScroll();
void DrawNextTimeStep();
void Reset();
void ReDraw();
int ConvertColor();
