/* File: rang.h
** Author: John C. Orthoefer <jco@reef.cis.ufl.edu>
**         Brian Bartholomew <bb@math.ufl.edu>
** Date: 09 Nov 1990
*/

#ifdef INRANG
#define defdouble double
#else
#define defdouble extern double
#endif

#ifdef UNIX
#define CommentChar '#'
#elif VMS
#define CommentChar '!'
#endif UNIX

#define fnasn(q) atan((q) / sqrt(-(q)*(q)+1.0))

/* Operational Defaults */
#define Dmode 1 

/* Simulation Defaults */
#define DVel 32.0
#define Daim 15.0
#define Dtilt 10.0
#define DLayDown 7.0
#define DElevation 30.0

defdouble Pi;
defdouble Deg2Pi;
defdouble W1, W2, W3, W4, W5, W6, W7, W8, W9;
defdouble K1, K3;
defdouble E;
defdouble X, Y, Z;
defdouble B0, B1;
defdouble Bx, By;
defdouble L;
defdouble T;
defdouble G;
defdouble XRL, YRL;
defdouble M;
defdouble V;
defdouble Da, Dg;
defdouble Dx, Dy, Dz;
defdouble D1, D2, D3, D4, D5;
defdouble Q;
defdouble Bk;
defdouble D;
defdouble S;
defdouble aim, tilt, LayDown, Elevation, Vel;
