//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//---------------------------------------------

#include <stream.h>

class contrk {
 private:
    float in[4],out[4],f[4],savevar[4],delta_time;
    int num_equations;
  public:
    contrk();
    void next_state();
    void integrate();
    void print_time();
  };

contrk con1;
float simtime;

main()
{
  simtime = 0.0;
  while (simtime < 5.0) {
   con1.next_state();
   con1.integrate(); 
   // output time,x 
   con1.print_time();
  } // end while 
} // end main 

contrk::contrk()
{
  num_equations = 3;
  out[1] = 1.0;
  out[2] = 1.0;
  out[3] = 1.0;
  delta_time = 0.01;
}

void contrk::next_state()
{ 
// Calculate state: x''' + x' = 2 
 in[1] = out[2];
 in[2] = out[3];
 in[3] = 2 - out[2];
}
 
void contrk::integrate()
{
  int i;

  for (i=1;i<=num_equations;i++) {
    f[i] = delta_time*in[i];
    savevar[i] = out[i];
    out[i] += f[i]/2;
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i]/2;
  }
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i];
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) 
    out[i] = savevar[i] + (f[i] + delta_time*in[i])/6;
}

void contrk::print_time()
{
  cout<<simtime<<"  "<<out[1]<<"\n";
}
