/*
 * plotX11.h - X11 variables and declarations used by all X11 routines.
 */

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include "PXplot.h"

/*
 * EXTERNAL DECLARATIONS
 */
extern int  PXAllocColors();
extern int  PXlinetypX();
extern void PXmarkerX();
extern void PXnamedColorX();
extern void PXlineColorX();
extern void PXfillColorX();
extern void PXsetColorX();
extern int  PXpolyColorIndexX();

extern void PXfillX_polygon();

extern void PXplotX_linelabels();
extern void PXplotX_contscale();

extern void PXtranslate_world_to_X11();
extern void PXtranslate_X11_to_world();

extern int  PXdrawplotX();
extern void PXdrawplotX2D();
extern void PXdrawplotX3D();

unsigned long background_pixel;               /* color of background     */
unsigned long foreground_pixel;               /* color of foreground     */
unsigned long colors[PX_MAX_COLORS];          /* color pixel values      */
int           dark_background;                /* background hints        */

/* Widgets and X11-related variables */
Display     *display;                   /* display */
Window      window;                     /* parent window */
Pixmap      pixmap;                     /* pixmap to draw into */
XFontStruct *font_info;                 /* font information */
XFontStruct *lblfont_info;              /* label font information */
GC          gc, gcl;                    /* graphics context */
int         font_height, font_width;    /* More font info   */
int         lblfont_height;             /* More font info   */

/* plot information */
#define X_ORG            5
#define Y_ORG            5
#define X_DIM            600
#define Y_DIM            800
#define DEFAULT_BDR_DIM  65
#define LABEL_WIDTH      30

/* Misc */
#define DEFAULT_BORDER_WIDTH  3
#define Helv12B "-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1"
#define DEFAULT_FONT          Helv12B
#define ALT_FONT              "8x13"
#define SMALL_FONT            "6x10"
#define MAXCHR                CN_MAXCHAR

/* The dimensions of the Xwindow plot */
int Xxmin, Xxmax, Xymin, Xymax, Width, Height;


