/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.1						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/*								*/
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

#include <stdio.h>
#include <sys/param.h>
#include <sys/times.h>

#ifndef CLK_TCK
#include <unistd.h>
#define  CLK_TCK  sysconf(_SC_CLK_TCK)
#endif  /* CLK_TCK */

#define FL_WIDTH 150
#define LOAD 1
#define SAVE 2
#define YES 1
#define NO 0

#ifdef NO_XAW
#define XawRubber XtRubber
#define XawChainTop XtChainTop
#define XawChainBottom XtChainBottom
#define XawChainLeft XtChainLeft
#define XawChainRight XtChainRight
#endif


/*----------------------------------------------------------------------*/

typedef struct {
  void (*func)(char *, char);
  Widget freq_window;
  Widget file_path;
  Widget file_name;
  Widget file_list;
  char **dirlist;           /* used by the list widget */
  char fpath[MAXPATHLEN];
  char fname[MAXPATHLEN];
  clock_t last_click;        /* time of last click */
  char doWhat;		     /* load or save */	
} FReqData;

static FReqData fdata;

/*----------------------------------------------------------------------*/
/* Prototypes								*/
/*----------------------------------------------------------------------*/

#include "dirlist.h"
static void load_list(Widget, char *, int, FReqData *);
void FilelistPrompter(Widget, char *, FReqData *);

/*----------------------------------------------------------------------*/
/* This function is just a wrapper for mystrcmp(), and is called by     */
/* qsort() (if used) down below.					*/
/*----------------------------------------------------------------------*/ 

static int mystrcmp(const void *a, const void *b)
{
  return strcmp(*(char **)a, *(char **)b);
}

/*----------------------------------------------------------------------*/
/* Callbacks */
/*----------------------------------------------------------------------*/


void list_callback(widget, clientData, callData)
  Widget widget;
  XtPointer clientData, callData;
{
  XawListReturnStruct *list;
  FReqData *fdata;
  Arg arg;
  
  list = (XawListReturnStruct *)callData;
  fdata = (FReqData *)clientData;
  
  load_list(widget, list->string, list->list_index, fdata);
  
  XtSetArg(arg, XtNstring, fdata->fpath);
  XtSetValues(fdata->file_path, &arg, 1);
  XtSetArg(arg, XtNstring, fdata->fname);
  XtSetValues(fdata->file_name, &arg, 1);
}

/*----------------------------------------------------------------------*/

void load_callback(widget, clientData, callData)
  Widget widget;
  XtPointer clientData, callData;
{
  FReqData *fdata;
  char fullname[MAXPATHLEN];
  
  fdata = (FReqData *)clientData;
  if ('/' == fdata->fname[strlen(fdata->fname)-1]) {
    load_list(widget, fdata->fname, -1, fdata);
    return;
  }   
  sprintf(fullname, "%s%s", fdata->fpath, fdata->fname);
  fdata->func(fullname, LOAD); 
  XtDestroyWidget(fdata->freq_window);
}

/*----------------------------------------------------------------------*/

void save_callback(widget, clientData, callData)
  Widget widget;
  XtPointer clientData, callData;
{
  FReqData *fdata;
  char fullname[MAXPATHLEN];
  Arg wargs[5];
  int n, promptAnswer = 0;
  String str;
  FILE *output;
  Widget prompter;
 
  if (!clientData)
    return;  
  fdata = (FReqData *)clientData;
  if ('/' == fdata->fname[strlen(fdata->fname)-1]) { /* not a file but */
    load_list(widget, fdata->fname, -1, fdata);	     /* a directory */	
    return;
  }
  n = 0;
  XtSetArg(wargs[n], XtNstring, &str); n++;
  XtGetValues(fdata->file_name, wargs, n);
  strcpy(fdata->fname, str);   
  sprintf(fullname, "%s%s", fdata->fpath, fdata->fname);
  
  output = fopen(fullname,"r"); /* test if file exists */               
  if (output) {
    fclose(output);
    FilelistPrompter(fdata->freq_window, "File exists. Overwrite?", fdata);
  } 
  else {
    fdata->func(fullname, SAVE); 
    XtDestroyWidget(fdata->freq_window);
  }  
}

/*----------------------------------------------------------------------*/


void cancel_callback(widget, clientData, callData)
  Widget widget;
  XtPointer clientData, callData;
{
  FReqData *fdata;
  
  fdata = (FReqData *)clientData;
  fdata->func(NULL,0);
  XtDestroyWidget(fdata->freq_window);
}    

/*----------------------------------------------------------------------*/
/* Actions								*/
/*----------------------------------------------------------------------*/

void pathSelected(Widget widget, XEvent *eventAdr, 
	      String *params, Cardinal *paramsAnzAdr)
{
  Arg wargs[5];
  int n;
  String path;
  char savePath[MAXPATHLEN]; 
  char tryPath[MAXPATHLEN] = "";
  
  n = 0;
  XtSetArg(wargs[n], XtNstring, &path); n++;
  XtGetValues(widget, wargs, n);
  /* is first char '/' ? */
  if (path[0] == '/')
    /* delete it, because it will be added in load_list() */
    strcpy(tryPath, path+1);
  else  
    strcpy(tryPath, path);
  if (tryPath[strlen(tryPath)-1] != '/')  /* add '/' if not last char */
    strcat(tryPath, "/"); /* possibly dangerous */
    
  /* save current path */
  strcpy(savePath, fdata.fpath);
  /* clear path */
  fdata.fpath[0] = '\0';
  
  /* try to load new file-list of the input-path */
  load_list(fdata.file_list, tryPath, -1, &fdata);
  
  /* could a new directory be loaded ? */
  if (fdata.fpath[0] == '\0') {
    /* restore old path */
    strcpy(fdata.fpath, savePath);
    XBell(XtDisplay(widget), 0);
  }
  n = 0;
  XtSetArg(wargs[n], XtNstring, fdata.fpath); n++;
  XtSetValues(widget, wargs, n);  
}

/*----------------------------------------------------------------------*/

void fileSelected(Widget widget, XEvent *eventAdr, 
	      String *params, Cardinal *paramsAnzAdr)
{
  Arg wargs[5];
  int n;
  String file;
  
  n = 0;
  XtSetArg(wargs[n], XtNstring, &file); n++;
  XtGetValues(widget, wargs, n);

  strcpy(fdata.fname, file);
  if (LOAD == fdata.doWhat)
    load_callback(fdata.freq_window, (XtPointer)&fdata, NULL);      
  else if (SAVE == fdata.doWhat)
    save_callback(fdata.freq_window, (XtPointer)&fdata, NULL); 
}     

/*----------------------------------------------------------------------*/
/* Erzeugen des File-List-Fensters (Schnittstellenfunktion)		*/
/*----------------------------------------------------------------------*/

Widget FileDialog(Widget popupParent,	/* parent widget */ 
        	  void (*doOnSelect)(char *, char), /* pointer to function */ 
                  char what,		/* load or save */
                  char *name)		/* title of popup shell */
{
  Window dummyWindow;
  int dummyInt, root_x, root_y, width;
  unsigned int dummyUInt;
  Arg wargs[20];
  int n=0;
  Widget popupShell, popup, form, box, vport, list;
  Widget w[10];
  int num_entries;

  if (popupParent == NULL)
    return NULL;

  fdata.func = doOnSelect;
  fdata.doWhat = what;

  /* --- Dialog mit List-Widget --- */
  
  XQueryPointer(XtDisplay(popupParent), XtWindow(popupParent),
        	&dummyWindow, &dummyWindow,
                &root_x, &root_y,
                &dummyInt, &dummyInt, &dummyUInt);
  root_x = (root_x >= 50 ? root_x-50 : root_x);
  root_y = (root_y >= 50 ? root_y-50 : root_y);
  
  n=0;
  XtSetArg(wargs[n], XtNtitle,    "File Dialog");      n++;
  XtSetArg(wargs[n], XtNiconName, "File Dialog");     n++;
  XtSetArg(wargs[n], XtNx, root_x);     n++;
  XtSetArg(wargs[n], XtNy, root_y);     n++;
  
  popupShell = XtCreatePopupShell("popupShell", transientShellWidgetClass,
        	popupParent, wargs, n);
  if (popupShell == NULL)
    return NULL;  
  
  fdata.freq_window = popupShell;
  
  n=0;
  XtSetArg(wargs[n], XtNvertDistance, 0);     	n++;
  XtSetArg(wargs[n], XtNhorizDistance, 0);     	n++;
  XtSetArg(wargs[n], XtNborderWidth, 0);      	n++; 
  form = XtCreateManagedWidget("form", formWidgetClass,
     	popupShell, wargs, n);        
           
  /* ---- Liste erzeugen ---- */
  n = 0;
  XtSetArg(wargs[n], XtNwidth, FL_WIDTH );             n++;
  XtSetArg(wargs[n], XtNheight, 200);            n++;
  XtSetArg(wargs[n], XtNallowVert, True);           n++;
  XtSetArg(wargs[n], XtNallowHoriz, False);          n++;
  XtSetArg(wargs[n], XtNuseBottom, True);           n++;

  vport = XtCreateManagedWidget("vport", viewportWidgetClass,
        	form ,wargs, n);
  if (vport == NULL)
    return NULL;

  getwd(fdata.fpath);
  if(fdata.fpath[strlen(fdata.fpath)-1] != '/')
    strcat(fdata.fpath, "/");
    
  fdata.dirlist = get_dir_list(NULL, &num_entries);
  qsort(fdata.dirlist, num_entries, sizeof(char *), mystrcmp);

  n = 0;
  XtSetArg(wargs[n], XtNlist, fdata.dirlist);       n++;
  XtSetArg(wargs[n], XtNverticalList, True);        n++;
  XtSetArg(wargs[n], XtNforceColumns, True);        n++;
  XtSetArg(wargs[n], XtNdefaultColumns, 1);         n++;
  XtSetArg(wargs[n], XtNborderWidth, 1);            n++;
  
  list = XtCreateManagedWidget("list", listWidgetClass,
			       vport,wargs,n);
  if (list == NULL)
   {
     XtDestroyWidget(vport);
     return NULL;
   }
   
  fdata.file_list = list; 
  
  XtAddCallback(list, XtNcallback, list_callback, (XtPointer)&fdata);

  /* ---- end Liste ---- */
  
  n=0;
  XtSetArg(wargs[n], XtNwidth, FL_WIDTH);     	n++;
  XtSetArg(wargs[n], XtNvSpace, 1);     	n++;
  XtSetArg(wargs[n], XtNhSpace, 1);     	n++;
  XtSetArg(wargs[n], XtNborderWidth, 0);      	n++;
  XtSetArg(wargs[n], XtNorientation, XtorientHorizontal);     	n++;
  
  box = XtCreateManagedWidget("box", boxWidgetClass,
        	form, wargs, n);                   
                           
  w[0] = XtCreateManagedWidget("Path:", labelWidgetClass, 
        	form, NULL, 0);                            
  w[1] = XtCreateManagedWidget("File:", labelWidgetClass, 
        	form, NULL, 0); 
                
  n=0;
  XtSetArg(wargs[n], XtNwidth, &width);      	n++;              
  XtGetValues(w[0], wargs, n);
                
  n=0;
  XtSetArg(wargs[n], XtNlabel, "");      	n++;
  XtSetArg(wargs[n], XtNwrap, XawtextWrapNever);      	n++;
  XtSetArg(wargs[n], XtNwidth, FL_WIDTH - width);      	n++; 
  XtSetArg(wargs[n], XtNeditType, XawtextEdit);      	n++;
  w[2] = XtCreateManagedWidget("ptext", asciiTextWidgetClass, 
        	form, wargs, n);               
  w[3] = XtCreateManagedWidget("ftext", asciiTextWidgetClass, 
        	form, wargs, n);
  XtOverrideTranslations(w[2], XtParseTranslationTable(
                        	"<Key>Return:pathSelected()"));              
  XtOverrideTranslations(w[3], XtParseTranslationTable(
                        	"<Key>Return:fileSelected()"));

  fdata.file_path = w[2];
  fdata.file_name = w[3];
                                               
  w[4] = XtCreateManagedWidget("Load", commandWidgetClass,
                	box ,NULL,0);
  if (what == SAVE) { /* disable Load-Button */
    n = 0;
    XtSetArg(wargs[n], XtNsensitive, False);	n++;
    XtSetValues(w[4], wargs, n);
  }  
  XtAddCallback(w[4], XtNcallback, load_callback, (XtPointer)&fdata);                      
  w[5] = XtCreateManagedWidget("Save", commandWidgetClass,
                	box ,NULL,0);                        
  if (what == LOAD) { /* disable Save-Button */
    n = 0;
    XtSetArg(wargs[n], XtNsensitive, False);	n++;
    XtSetValues(w[5], wargs, n);
  }                          
  XtAddCallback(w[5], XtNcallback, save_callback, (XtPointer)&fdata);                             
  w[6] = XtCreateManagedWidget("Cancel", commandWidgetClass,
			       box,NULL,0);
  XtAddCallback(w[6], XtNcallback, cancel_callback, (XtPointer)&fdata); 
  
  
  n = 0; 
  XtSetArg(wargs[n], XtNtop, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetArg(wargs[n], XtNleft, XawRubber);      n++;
  XtSetValues(vport, wargs, n);
  
  n = 0; 
  XtSetArg(wargs[n], XtNright, XawChainLeft);      n++;
  XtSetArg(wargs[n], XtNleft, XawChainLeft);      n++;
  XtSetValues(w[0], wargs, n);
  XtSetValues(w[1], wargs, n);
  
  n = 0; 
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetArg(wargs[n], XtNleft, XawChainLeft);      n++;
  XtSetValues(w[2], wargs, n);
  XtSetValues(w[3], wargs, n);
  
  n = 0; XtSetArg(wargs[n], XtNfromVert, vport);      n++;
  XtSetValues(w[0], wargs, n);
  XtSetValues(w[2], wargs, n);
  n = 0; XtSetArg(wargs[n], XtNfromHoriz, w[0]);      n++;
  XtSetValues(w[2], wargs, n);
  n = 0; XtSetArg(wargs[n], XtNfromVert, w[0]);      n++;
  XtSetValues(w[1], wargs, n);
  n = 0; XtSetArg(wargs[n], XtNfromVert, w[2]);      n++;
  XtSetValues(w[3], wargs, n);
  n = 0; XtSetArg(wargs[n], XtNfromHoriz, w[1]);      n++;
  XtSetValues(w[3], wargs, n);
  
  n = 0; 
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetArg(wargs[n], XtNleft, XawRubber);      n++;
  XtSetArg(wargs[n], XtNbottom, XawChainBottom);      n++;
  XtSetArg(wargs[n], XtNfromVert, w[1]);      n++;
  XtSetValues(box, wargs, n);
                                                
  XtRealizeWidget(popupShell);
  XtPopup(popupShell, XtGrabExclusive);
     
  return;    
}

/* ---------------------------------------------------------------------*/
/* Routinen fr List-Dialog 					*/
/* ---------------------------------------------------------------------*/

/*
 * load_list() - Callback routine for scrollable list widget
 */
static void load_list(Widget w, char *string,  int index, FReqData *fdata)
{
  char newpath[MAXPATHLEN], *cptr, *fpath, fullname[MAXPATHLEN];
  char **old_dirlist=NULL;
  static char oldfile[MAXPATHLEN] = { '\0', };
  clock_t cur_click;
  struct tms junk_tms;  /* not used, but passed to times() */
  int num_dir;
  float tdiff;    /* difference in time between two clicks as % of a second */
  
  if (-1 != index) {  /* function was explicite invoked */ 
    cur_click = times(&junk_tms);
    tdiff = ((float)(cur_click - fdata->last_click) / CLK_TCK);

    if(tdiff > 0.50 || strcmp(oldfile, string) != 0) {
      fdata->last_click = cur_click;
      strcpy(oldfile, string);
      strcpy(fdata->fname, string);
      return;
    }
  }
  /* check if a directory was selected */
  if(string[strlen(string)-1] != '/')   /* a regular file double click */
   { 
     load_callback(fdata->freq_window, (XtPointer)fdata, NULL);
     return;
   }

  /*
   * Else, we've got a directory name and should deal with it
   * as approrpriate.
   */

  /* check for special cases "./" and "../" */
  if(strcmp(string, "./") == 0)
   {
     if (fdata->fpath)
       strcpy(newpath, fdata->fpath);
     else
       strcpy(newpath, "./");
   }
  else if(strcmp(string, "../") == 0)
   {
     strcpy(newpath, fdata->fpath);
     
     if (strcmp(newpath, "./") == 0)
       strcpy(newpath, string);
     else 
      {
	/*
	 * chop off the last path component and look at what it 
	 * is to determine what to do with the `..' we just got.
	 */
	cptr = strrchr(newpath, '/');
	if (cptr)
	  *cptr = '\0';
	cptr = strrchr(newpath, '/');
	if (cptr)
	  *cptr = '\0';

	if (  (cptr != NULL && strcmp(cptr+1,  "..") == 0)
	    ||(cptr == NULL && strcmp(newpath, "..") == 0))
	 {
	   if (cptr)
	     *cptr = '/';

	   strcat(newpath, "/");      /* put back the / we took out */
	   strcat(newpath, "../");    /* and append the new ../ */
	 }
	else
	 {
	   if(cptr == NULL && strcmp(fdata->fpath, "/") == 0)
	     strcpy(newpath, "/");
	   else if (cptr == NULL)
	     strcpy(newpath, "./");

	   if (newpath[strlen(newpath)-1] != '/')
	     strcat(newpath, "/");
	 }
      }
   }
  else /* not a `./' or `../', so it's just a regular old directory name */
   {
     if (fdata->fpath[strlen(fdata->fpath)-1] == '/')
       sprintf(newpath, "%s%s", fdata->fpath, string);
     else
       sprintf(newpath, "%s/%s", fdata->fpath, string);
   }

  old_dirlist = fdata->dirlist;
  if(!(fdata->dirlist = get_dir_list(newpath, &num_dir)))
    /* should beep the display or something here */
    return; 
  
  qsort(fdata->dirlist, num_dir, sizeof(char *), mystrcmp);
  
  strcpy(fdata->fpath, newpath);
  XawListChange(fdata->file_list, fdata->dirlist, -1, -1, TRUE);
  
  /* free the directory list */
  if (old_dirlist)
    free_dirlist(old_dirlist);
  
  fdata->last_click = 0;  /* re-init double-click time */
  
  return;
}

/* -------------------------------------------------------------------*/
/* Prompter							      */
/* -------------------------------------------------------------------*/

/* Callbacks for prompter */

void prompt_yes(Widget widget, XtPointer clientData, XtPointer callData)
{
  FReqData *fdata;
  char fullname[MAXPATHLEN];
  
  if (clientData == NULL)
    return;
  fdata = (FReqData *)clientData;  
  sprintf(fullname, "%s%s", fdata->fpath, fdata->fname);  
  fdata->func(fullname, SAVE); 
  
  XtDestroyWidget(fdata->freq_window); /* destroy parent window */   
}

void prompt_no(Widget widget, XtPointer clientData, XtPointer callData)
{
  FReqData *fdata;
  
  if (clientData == NULL)
    return;
  fdata = (FReqData *)clientData;   
  
  XtDestroyWidget(fdata->freq_window); /* destoy parent window */  
}

/* -------------------------------------------------------------------*/

void FilelistPrompter(Widget popupParent, char *msg, FReqData *fdata)
{
  Window dummyWindow;
  int dummyInt, root_x, root_y;
  Arg wargs[20];
  int n=0;
  char *wName;
  Widget popupShell, popup, pform, pbutton;

  if (popupParent == NULL)
    return;
    
  XQueryPointer(XtDisplay(popupParent), XtWindow(popupParent),
        	&dummyWindow, &dummyWindow,
                &root_x, &root_y,
                &dummyInt, &dummyInt, &dummyInt);
  root_x = (root_x >= 50 ? root_x-50 : root_x);
  root_y = (root_y >= 50 ? root_y-50 : root_y);
    
  n=0;
  XtSetArg(wargs[n], XtNx, root_x);     n++;
  XtSetArg(wargs[n], XtNy, root_y);     n++;
  XtSetArg(wargs[n], XtNlabel, msg); 	n++; 
  popupShell = XtCreatePopupShell("popupShell", transientShellWidgetClass,
        	popupParent, wargs, n);
  if (popupShell == NULL)
    return;  
  
  popup = XtCreateManagedWidget("dialog", dialogWidgetClass,
          popupShell, wargs, n);              

  XawDialogAddButton(popup, "Yes", prompt_yes, (XtPointer)fdata); 
  XawDialogAddButton(popup, "No", prompt_no, (XtPointer)fdata);   
 
  XtRealizeWidget(popupShell);            
  XtPopup(popupShell, XtGrabExclusive); 
}
