//
// Msql client library for JAVA
// Copyright (C) 1995 Darryl Collins <darryl@minmet.uq.oz.au>
// This software is provided "as is" without any expressed or implied warranty.
//
// This package implements a client for the mSQL server designed and
// implemented by David Hughes <bambi@hughes.com.au>
//
// $Log: MsqlRow.java,v $
// Revision 1.1.1  1996/02/15 06:12:39  root
// Initial revision
//
//

package imaginary.sql.msql;

import java.awt.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Storage for a single row of a table.  MsqlData is a set of MsqlRow structures.
 */
class MsqlRow {

	private int nCols;
	private String strData[];

/**
 * Constructor - accepts number of cols as argument
 */
	public MsqlRow(int n) {

		nCols = n;
		strData = new String[nCols];
	}

/**
 * Constructor - duplicates another row
 */
	public MsqlRow(MsqlRow r) {
		
		nCols = r.nCols;
		strData = new String[nCols];
	
		for(int i=0; i<nCols; i++)
			if(r.strData[i] != null)
				strData[i] = new String(r.strData[i]);
	}

/**
 * Returns contents as array of strings 
 */
	public String [] rowData() {

		return strData;
	}

/**
 * Adds a new field to the row
 */
	public void addField(int i, String s) {

		if(s != null) strData[i] = new String(s);
	}

/**
 * Returns number of cols
 */
	public int NumFields() {
		
		return nCols;
	}
}

