/*----------------------------------------------------------------
 *   FILE
 *	fmgr.h
 *
 *   DESCRIPTION
 *	Definitions for using internal procedures.
 *
 *   NOTES
 *	******************************
 *	*** DO NOT EDIT THIS FILE! ***
 *	******************************
 *
 *	It has been GENERATED by ../utils/Gen_fmgrtab.sh
 *	from ../catalog/pg_proc.h
 *
 *   IDENTIFICATION
 *	$Header: /usr/local/devel/postgres/src/backend/utils/RCS/Gen_fmgrtab.sh,v 1.3 1993/01/09 02:49:20 aoki Exp $
 *----------------------------------------------------------------
 */

#ifndef	FMgrIncluded		/* Include this file only once */
#define FMgrIncluded	1

#include "tmp/c.h"

typedef char *	((*func_ptr)());	/* ptr to func returning (char *) */

#include "utils/dynamic_loader.h"

/*
 *	Maximum number of arguments for a built-in function.
 *
 *	XXX note that you cannot call a function with more than 8 
 *	    arguments from the user level since the catalogs only 
 *	    store 8 argument type values for type-checking ...
 */
#define	MAXFMGRARGS	9

typedef struct {
	char	*data[MAXFMGRARGS];
} FmgrValues;

/*
 * defined in fmgr.c
 */
extern char	*fmgr_c ARGS((
	func_ptr user_fn,
	ObjectId func_id,
	int n_arguments,
	char *values,
	Boolean *isNull
));
extern char	*fmgr ARGS((...));	/* XXX varargs */
extern char	*fmgr_ptr ARGS((...));	/* XXX varargs */
extern char	*fmgr_array_args ARGS(( /* XXX this routine is going away */
	ObjectId procedureId,
	int nargs,
	char *args[],
	Boolean *isNull
));
extern void	fmgr_info ARGS((
	ObjectId procedureId,
	func_ptr *function,
	int *nargs
));

/*
 * defined in dfmgr.c
 */
extern func_ptr	fmgr_dynamic ARGS((
	ObjectId	procedureId,
	int		*pronargs
));

/*
 * defined in ufp.c
 */
extern char	*fmgr_ufp ARGS((
	ObjectId	func_id,
	Datum		*values
));

/*
 *	For performance reasons, we often want to simply jump through a
 *	a function pointer (if it's valid, that is).  These calls have
 *	been macroized so we can run them through a routine that does
 *	sanity-checking (and so we can track them down more easily when
 *	we must).
 */
#ifdef TRACE_FMGR_PTR
#define	FMGR_PTR2(FP, FID, ARG1, ARG2) 	fmgr_ptr(FP, FID, 2, ARG1, ARG2)
#else
#define	FMGR_PTR2(FP, FID, ARG1, ARG2) 	((FP) ? (*((func_ptr)(FP)))(ARG1, ARG2) : fmgr(FID, ARG1, ARG2))
#endif

/*
 *	Flags for the builtin oprrest selectivity routines.
 */
#define	SEL_CONSTANT 	1	/* constant does not vary (not a parameter) */
#define	SEL_RIGHT	2 	/* constant appears to right of operator */

#define F_BOOLIN 28
#define F_BOOLOUT 29
#define F_BYTEAIN 30
#define F_BYTEAOUT 31
#define F_CHARIN 32
#define F_CHAROUT 33
#define F_CHAR16IN 34
#define F_CHAR16OUT 35
#define F_DTIN 36
#define F_DTOUT 37
#define F_INT2IN 38
#define F_INT2OUT 39
#define F_INT28IN 40
#define F_INT28OUT 41
#define F_INT4IN 42
#define F_INT4OUT 43
#define F_REGPROCIN 44
#define F_REGPROCOUT 45
#define F_TEXTIN 46
#define F_TEXTOUT 47
#define F_TIDIN 48
#define F_TIDOUT 49
#define F_XIDIN 50
#define F_XIDOUT 51
#define F_CIDIN 52
#define F_CIDOUT 53
#define F_OID8IN 54
#define F_OID8OUT 55
#define F_LOCKIN 56
#define F_LOCKOUT 57
#define F_STUBIN 58
#define F_STUBOUT 59
#define F_BOOLEQ 60
#define F_CHAREQ 61
#define F_CHAR16EQ 62
#define F_INT2EQ 63
#define F_INT2LT 64
#define F_INT4EQ 65
#define F_INT4LT 66
#define F_TEXTEQ 67
#define F_XIDEQ 68
#define F_CIDEQ 69
#define F_CHARNE 70
#define F_CHARLT 71
#define F_CHARLE 72
#define F_CHARGT 73
#define F_CHARGE 74
#define F_CHARPL 75
#define F_CHARMI 76
#define F_CHARMUL 77
#define F_CHARDIV 78
#define F_CHAR16REGEXEQ 79
#define F_CHAR16REGEXNE 80
#define F_TEXTREGEXEQ 81
#define F_TEXTREGEXNE 82
#define F_BOOLNE 84
#define F_RTSEL 97
#define F_RTNPAGE 98
#define F_BTREESEL 99
#define F_BTREENPAGE 100
#define F_EQSEL 101
#define F_NEQSEL 102
#define F_INTLTSEL 103
#define F_INTGTSEL 104
#define F_EQJOINSEL 105
#define F_NEQJOINSEL 106
#define F_INTLTJOINSEL 107
#define F_INTGTJOINSEL 108
#define F_POINT_IN 117
#define F_POINT_OUT 118
#define F_LSEG_IN 119
#define F_LSEG_OUT 120
#define F_PATH_IN 121
#define F_PATH_OUT 122
#define F_BOX_IN 123
#define F_BOX_OUT 124
#define F_BOX_OVERLAP 125
#define F_BOX_GE 126
#define F_BOX_GT 127
#define F_BOX_EQ 128
#define F_BOX_LT 129
#define F_BOX_LE 130
#define F_POINT_ABOVE 131
#define F_POINT_LEFT 132
#define F_POINT_RIGHT 133
#define F_POINT_BELOW 134
#define F_POINT_EQ 135
#define F_ON_PB 136
#define F_ON_PPATH 137
#define F_BOX_CENTER 138
#define F_AREASEL 139
#define F_AREAJOINSEL 140
#define F_INT4MUL 141
#define F_INT4FAC 142
#define F_POINTDIST 143
#define F_INT4NE 144
#define F_INT2NE 145
#define F_INT2GT 146
#define F_INT4GT 147
#define F_INT2LE 148
#define F_INT4LE 149
#define F_INT4GE 150
#define F_INT2GE 151
#define F_INT2MUL 152
#define F_INT2DIV 153
#define F_INT4DIV 154
#define F_INT2MOD 155
#define F_INT4MOD 156
#define F_TEXTNE 157
#define F_INT24EQ 158
#define F_INT42EQ 159
#define F_INT24LT 160
#define F_INT42LT 161
#define F_INT24GT 162
#define F_INT42GT 163
#define F_INT24NE 164
#define F_INT42NE 165
#define F_INT24LE 166
#define F_INT42LE 167
#define F_INT24GE 168
#define F_INT42GE 169
#define F_INT24MUL 170
#define F_INT42MUL 171
#define F_INT24DIV 172
#define F_INT42DIV 173
#define F_INT24MOD 174
#define F_INT42MOD 175
#define F_INT2PL 176
#define F_INT4PL 177
#define F_INT24PL 178
#define F_INT42PL 179
#define F_INT2MI 180
#define F_INT4MI 181
#define F_INT24MI 182
#define F_INT42MI 183
#define F_OIDEQ 184
#define F_OIDNE 185
#define F_BOX_SAME 186
#define F_BOX_CONTAIN 187
#define F_BOX_LEFT 188
#define F_BOX_OVERLEFT 189
#define F_BOX_OVERRIGHT 190
#define F_BOX_RIGHT 191
#define F_BOX_CONTAINED 192
#define F_RT_BOX_UNION 193
#define F_RT_BOX_INTER 194
#define F_RT_BOX_SIZE 195
#define F_RT_BIGBOX_SIZE 196
#define F_RT_POLY_UNION 197
#define F_RT_POLY_INTER 198
#define F_RT_POLY_SIZE 199
#define F_FLOAT4IN 200
#define F_FLOAT4OUT 201
#define F_FLOAT4MUL 202
#define F_FLOAT4DIV 203
#define F_FLOAT4PL 204
#define F_FLOAT4MI 205
#define F_FLOAT4UM 206
#define F_FLOAT4ABS 207
#define F_FLOAT4INC 208
#define F_FLOAT4LARGER 209
#define F_FLOAT4SMALLER 211
#define F_INT4UM 212
#define F_INT2UM 213
#define F_FLOAT8IN 214
#define F_FLOAT8OUT 215
#define F_FLOAT8MUL 216
#define F_FLOAT8DIV 217
#define F_FLOAT8PL 218
#define F_FLOAT8MI 219
#define F_FLOAT8UM 220
#define F_FLOAT8ABS 221
#define F_FLOAT8INC 222
#define F_FLOAT8LARGER 223
#define F_FLOAT8SMALLER 224
#define F_DROUND 228
#define F_DTRUNC 229
#define F_DSQRT 230
#define F_DCBRT 231
#define F_DPOW 232
#define F_DEXP 233
#define F_DLOG1 234
#define F_NABSTIMEIN 240
#define F_NABSTIMEOUT 241
#define F_RELTIMEIN 242
#define F_RELTIMEOUT 243
#define F_TIMEPL 244
#define F_TIMEMI 245
#define F_TINTERVALIN 246
#define F_TINTERVALOUT 247
#define F_ININTERVAL 248
#define F_INTERVALREL 249
#define F_TIMENOW 250
#define F_ABSTIMEEQ 251
#define F_ABSTIMENE 252
#define F_ABSTIMELT 253
#define F_ABSTIMEGT 254
#define F_ABSTIMELE 255
#define F_ABSTIMEGE 256
#define F_RELTIMEEQ 257
#define F_RELTIMENE 258
#define F_RELTIMELT 259
#define F_RELTIMEGT 260
#define F_RELTIMELE 261
#define F_RELTIMEGE 262
#define F_INTERVALEQ 263
#define F_INTERVALCT 264
#define F_INTERVALOV 265
#define F_INTERVALLENEQ 266
#define F_INTERVALLENNE 267
#define F_INTERVALLENLT 268
#define F_INTERVALLENGT 269
#define F_INTERVALLENLE 270
#define F_INTERVALLENGE 271
#define F_INTERVALSTART 272
#define F_INTERVALEND 273
#define F_INT2FAC 276
#define F_FLOAT48MUL 279
#define F_FLOAT48DIV 280
#define F_FLOAT48PL 281
#define F_FLOAT48MI 282
#define F_FLOAT84MUL 283
#define F_FLOAT84DIV 284
#define F_FLOAT84PL 285
#define F_FLOAT84MI 286
#define F_FLOAT4EQ 287
#define F_FLOAT4NE 288
#define F_FLOAT4LT 289
#define F_FLOAT4LE 290
#define F_FLOAT4GT 291
#define F_FLOAT4GE 292
#define F_FLOAT8EQ 293
#define F_FLOAT8NE 294
#define F_FLOAT8LT 295
#define F_FLOAT8LE 296
#define F_FLOAT8GT 297
#define F_FLOAT8GE 298
#define F_FLOAT48EQ 299
#define F_FLOAT48NE 300
#define F_FLOAT48LT 301
#define F_FLOAT48LE 302
#define F_FLOAT48GT 303
#define F_FLOAT48GE 304
#define F_FLOAT84EQ 305
#define F_FLOAT84NE 306
#define F_FLOAT84LT 307
#define F_FLOAT84LE 308
#define F_FLOAT84GT 309
#define F_FLOAT84GE 310
#define F_FTOD 311
#define F_DTOF 312
#define F_I2TOI4 313
#define F_I4TOI2 314
#define F_KEYFIRSTEQ 315
#define F_RTINSERT 320
#define F_RTDELETE 321
#define F_RTGETTUPLE 322
#define F_RTBUILD 323
#define F_RTBEGINSCAN 324
#define F_RTENDSCAN 325
#define F_RTMARKPOS 326
#define F_RTRESTRPOS 327
#define F_RTRESCAN 328
#define F_BTGETTUPLE 330
#define F_BTINSERT 331
#define F_BTDELETE 332
#define F_BTBEGINSCAN 333
#define F_BTRESCAN 334
#define F_BTENDSCAN 335
#define F_BTMARKPOS 336
#define F_BTRESTRPOS 337
#define F_BTBUILD 338
#define F_POLY_SAME 339
#define F_POLY_CONTAIN 340
#define F_POLY_LEFT 341
#define F_POLY_OVERLEFT 342
#define F_POLY_OVERRIGHT 343
#define F_POLY_RIGHT 344
#define F_POLY_CONTAINED 345
#define F_POLY_OVERLAP 346
#define F_POLY_IN 347
#define F_POLY_OUT 348
#define F_BTINT2CMP 350
#define F_BTINT4CMP 351
#define F_BTINT42CMP 352
#define F_BTINT24CMP 353
#define F_BTFLOAT4CMP 354
#define F_BTFLOAT8CMP 355
#define F_BTOIDCMP 356
#define F_BTABSTIMECMP 357
#define F_BTCHARCMP 358
#define F_BTCHAR16CMP 359
#define F_BTTEXTCMP 360
#define F_LSEG_DISTANCE 361
#define F_LSEG_INTERPT 362
#define F_DIST_PS 363
#define F_DIST_PB 364
#define F_DIST_SB 365
#define F_CLOSE_PS 366
#define F_CLOSE_PB 367
#define F_CLOSE_SB 368
#define F_ON_PS 369
#define F_PATH_DISTANCE 370
#define F_DIST_PPTH 371
#define F_ON_SB 372
#define F_INTER_SB 373
#define F_ATT_BY_NAME 649
#define F_INT4NOTIN 650
#define F_OIDNOTIN 651
#define F_INT44IN 652
#define F_INT44OUT 653
#define F_ATT_BY_NUM 654
#define F_CHAR16LT 655
#define F_CHAR16LE 656
#define F_CHAR16GT 657
#define F_CHAR16GE 658
#define F_CHAR16NE 659
#define F_GETUSERNAME 710
#define F_USERFNTEST 711
#define F_BYTEAGETSIZE 720
#define F_BYTEAGETBYTE 721
#define F_BYTEASETBYTE 722
#define F_BYTEAGETBIT 723
#define F_BYTEASETBIT 724
#define F_PQTEST 730
#define F_TEXT_LT 740
#define F_TEXT_LE 741
#define F_TEXT_GT 742
#define F_TEXT_GE 743
#define F_ARRAY_IN 750
#define F_ARRAY_OUT 751
#define F_FILENAME_IN 752
#define F_FILENAME_OUT 753
#define F_SMGRIN 760
#define F_SMGROUT 761
#define F_SMGREQ 762
#define F_SMGRNE 763
#define F_LO_FILEIN 764
#define F_LO_FILEOUT 765
#define F_INT4INC 766
#define F_INT2INC 767
#define F_INT4LARGER 768
#define F_INT4SMALLER 769
#define F_INT2LARGER 770
#define F_INT2SMALLER 771
#define F_FIMPORT 900
#define F_FEXPORT 901
#define F_FABSTRACT 902
#define F_OIDINT4IN 920
#define F_OIDINT4OUT 921
#define F_OIDINT4LT 922
#define F_OIDINT4LE 923
#define F_OIDINT4EQ 924
#define F_OIDINT4GE 925
#define F_OIDINT4GT 926
#define F_OIDINT4NE 927
#define F_OIDINT4CMP 928
#define F_MKOIDINT4 929
#define F_OIDCHAR16IN 940
#define F_OIDCHAR16OUT 941
#define F_OIDCHAR16LT 942
#define F_OIDCHAR16LE 943
#define F_OIDCHAR16EQ 944
#define F_OIDCHAR16GE 945
#define F_OIDCHAR16GT 946
#define F_OIDCHAR16NE 947
#define F_OIDCHAR16CMP 948
#define F_MKOIDCHAR16 949
#define F_FILENAMETOOID 950
#define F_LOCREATOID 951
#define F_LOOPEN 952
#define F_LOCLOSE 953
#define F_LOREAD 954
#define F_LOWRITE 955
#define F_LOLSEEK 956
#define F_LOCREAT 957
#define F_LOTELL 958
#define F_LOFTRUNCATE 959
#define F_LOSTAT 960
#define F_LORENAME 961
#define F_LOMKDIR 962
#define F_LORMDIR 963
#define F_LOUNLINK 964
#define F_PFTP_READ 970
#define F_PFTP_WRITE 971
#define F_REGPROCTOOID 972
#define F_PATH_INTER 973
#define F_BOX_COPY 974
#define F_BOX_AREA 975
#define F_BOX_LENGTH 976
#define F_BOX_HEIGHT 977
#define F_BOX_DISTANCE 978
#define F_BOX_INTERSECT 980
#define F_BOX_DIAGONAL 981
#define F_PATH_N_LT 982
#define F_PATH_N_GT 983
#define F_PATH_N_EQ 984
#define F_PATH_N_LE 985
#define F_PATH_N_GE 986
#define F_PATH_LENGTH 987
#define F_POINT_COPY 988
#define F_POINT_VERT 989
#define F_POINT_HORIZ 990
#define F_POINT_DISTANCE 991
#define F_POINT_SLOPE 992
#define F_LSEG_CONSTRUCT 993
#define F_LSEG_INTERSECT 994
#define F_LSEG_PARALLEL 995
#define F_LSEG_PERP 996
#define F_LSEG_VERTICAL 997
#define F_LSEG_HORIZONTAL 998
#define F_LSEG_EQ 999
#define F_NULLVALUE 1029
#define F_NONNULLVALUE 1030
#define F_ACLITEMIN 1031
#define F_ACLITEMOUT 1032
#define F_ACLINSERT 1035
#define F_ACLREMOVE 1036
#define F_ACLCONTAINS 1037

#endif	/* !defined(FMgrIncluded) */
