.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/load.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/load.cmdsrc,v 1.6 1993/01/26 02:43:13 aoki Exp $
.TH LOAD COMMANDS 01/23/93
.XA 2 Load
.SH NAME
load \(em dynamically load an object file
.SH SYNOPSIS
.(l M
\fBload\fR "filename"
.)l
.SH DESCRIPTION
.BR Load
loads an object (or ".o") file into \*(PG's address space.  Once a
file is loaded, all functions in that file can be accessed.  This
function is used in support of ADT's.
.PP
If a file is not loaded using the 
.BR load
command, the file will be loaded automatically the first time the
function is called by \*(PG.
.BR Load
can also be used to reload an object file if it has been edited and
recompiled.  Only objects created from C language files are supported
at this time.
.SH EXAMPLE
.(C
/*
 * Load the file /usr/postgres/demo/circle.o
 */
load "/usr/postgres/demo/circle.o"
.)C
.SH CAVEATS
Functions in loaded object files should not call functions in other
object files loaded through the
.BR load
command, meaning, for example, that all functions in file A should
call each other, functions in the standard or math libraries, or in
\*(PG itself.  They should not call functions defined in a different
loaded file B.  This is because if B is reloaded, the \*(PG loader is
not "smart" enough to relocate the calls from the functions in A into
the new address space of B.  If B is not reloaded, however, there will
not be a problem.
.PP
On diskless platforms or when running across NFS,
.BR load
can take two or three minutes or more, depending on network traffic.
On diskful platforms,
.BR load
takes from a few seconds on Suns and Sparcs to several minutes on
DECstations.
.PP
On DECstations, you must use 
.IR /bin/cc
with the \*(lq-G O\*(rq option when compiling object files to be
loaded.
.PP
Note that if you are porting \*(PG to a new platform, the
.BR load
command will have to work in order to support ADTs.
