/*
 * pos.c --
 *	POSTGRES "position" code.
 */

#include "tmp/c.h"

#include "storage/block.h"
#include "storage/off.h"
#include "storage/part.h"
#include "storage/pos.h"

#include "internal.h"

RcsId("$Header: /usr/local/devel/postgres/src/backend/storage/page/RCS/pos.c,v 1.5 1990/09/25 16:46:52 kemnitz Exp $");

/*
 *	A "position" ocnsists of "pageNumber ... offsetNumber"
 *	where pageNumber occupies a number of page bits determined
 *	by a PagePartition.
 */

bool
PositionIdIsValid(positionId, partition)
	PositionId	positionId;
	PagePartition	partition;
{
	return ((bool)(PointerIsValid(positionId) &&
			(*positionId & OffsetNumberMask(partition))));
}

void
PositionIdSet(positionId, partition, pageNumber, offsetNumber)
	PositionId	positionId;
	PagePartition	partition;
	PageNumber	pageNumber;
	OffsetNumber	offsetNumber;
{
    Assert((pageNumber >> PagePartitionGetNumberOfPageBits(partition)) == 0);
    Assert((offsetNumber >> PagePartitionGetNumberOfOffsetBits(partition))==0);

	*positionId = offsetNumber |
		(pageNumber << PagePartitionGetNumberOfOffsetBits(partition));
}

PageNumber
PositionIdGetPageNumber(positionId, partition)
	PositionId	positionId;
	PagePartition	partition;
{
/*
	Assert(PositionIdIsValid(positionId, partition));
*/

	return (0xffff &
		(*positionId >> PagePartitionGetNumberOfOffsetBits(partition)));
}

OffsetNumber
PositionIdGetOffsetNumber(positionId, partition)
	PositionId	positionId;
	PagePartition	partition;
{
	Assert(PositionIdIsValid(positionId, partition));

	return (*positionId & OffsetNumberMask(partition));
}
