#! /bin/sh
#----------------------------------------------------------------
#   FILE
#	Gen_fmgrtab.sh
#
#   DESCRIPTION
#       shell script to generate fmgr.h and fmgrtab.c from pg_proc.h
#
#   NOTES
#	Passes any -D options on to cpp prior to generating the list
#	of internal functions.  These come from BKIOPTS.
#
#   IDENTIFICATION
# 	$Header: /usr/local/devel/postgres/src/backend/utils/RCS/Gen_fmgrtab.sh,v 1.3 1993/01/09 02:49:20 aoki Exp $
#----------------------------------------------------------------

# cpp is usually in one of these two places...
PATH=/usr/lib:/lib:$PATH

BKIOPTS=''
if [ $? != 0 ]
then
	echo `basename $0`: Bad option
	exit 1
fi

#
# Pass on any -D declarations, throwing away any other command
# line switches.
#
for opt in $*
do
	case $opt in
	-D) BKIOPTS="$BKIOPTS -D$2"; shift; shift;;
	-D*) BKIOPTS="$BKIOPTS $1";shift;;
	--) shift; break;;
	-*) shift;;
	esac
done

INFILE=$1
RAWFILE=fmgr.raw
HFILE=fmgr.h
TABCFILE=fmgrtab.c

#
# Generate the file containing raw pg_proc tuple data
# (but only for "internal" language procedures...).
#
# Unlike genbki.sh, which can run through cpp last, we have to
# deal with preprocessor statements first (before we sort the
# function table by oid).
#
awk '
BEGIN		{ raw = 0; }
/^DATA/		{ print; next; }
/^BKI_BEGIN/	{ raw = 1; next; }
/^BKI_END/	{ raw = 0; next; }
raw == 1	{ print; next; }' $INFILE | \
sed 	-e 's/^.*OID[^=]*=[^0-9]*//' \
	-e 's/(//g' \
	-e 's/[ 	]*).*$//' | \
awk '
/^#/		{ print; next; }
$4 == "11"	{ print; next; }' | \
cpp $BKIOPTS | \
egrep '^[0-9]' | \
sort -n > $RAWFILE

#
# Generate fmgr.h
#
cat > $HFILE <<FuNkYfMgRsTuFf
/*----------------------------------------------------------------
 *   FILE
 *	$HFILE
 *
 *   DESCRIPTION
 *	Definitions for using internal procedures.
 *
 *   NOTES
 *	******************************
 *	*** DO NOT EDIT THIS FILE! ***
 *	******************************
 *
 *	It has been GENERATED by $0
 *	from $1
 *
 *   IDENTIFICATION
 *	\$Header: /usr/local/devel/postgres/src/backend/utils/RCS/Gen_fmgrtab.sh,v 1.3 1993/01/09 02:49:20 aoki Exp $
 *----------------------------------------------------------------
 */

#ifndef	FMgrIncluded		/* Include this file only once */
#define FMgrIncluded	1

#include "tmp/c.h"

typedef char *	((*func_ptr)());	/* ptr to func returning (char *) */

#include "utils/dynamic_loader.h"

/*
 *	Maximum number of arguments for a built-in function.
 *
 *	XXX note that you cannot call a function with more than 8 
 *	    arguments from the user level since the catalogs only 
 *	    store 8 argument type values for type-checking ...
 */
#define	MAXFMGRARGS	9

typedef struct {
	char	*data[MAXFMGRARGS];
} FmgrValues;

/*
 * defined in fmgr.c
 */
extern char	*fmgr_c ARGS((
	func_ptr user_fn,
	ObjectId func_id,
	int n_arguments,
	char *values,
	Boolean *isNull
));
extern char	*fmgr ARGS((...));	/* XXX varargs */
extern char	*fmgr_ptr ARGS((...));	/* XXX varargs */
extern char	*fmgr_array_args ARGS(( /* XXX this routine is going away */
	ObjectId procedureId,
	int nargs,
	char *args[],
	Boolean *isNull
));
extern void	fmgr_info ARGS((
	ObjectId procedureId,
	func_ptr *function,
	int *nargs
));

/*
 * defined in dfmgr.c
 */
extern func_ptr	fmgr_dynamic ARGS((
	ObjectId	procedureId,
	int		*pronargs
));

/*
 * defined in ufp.c
 */
extern char	*fmgr_ufp ARGS((
	ObjectId	func_id,
	Datum		*values
));

/*
 *	For performance reasons, we often want to simply jump through a
 *	a function pointer (if it's valid, that is).  These calls have
 *	been macroized so we can run them through a routine that does
 *	sanity-checking (and so we can track them down more easily when
 *	we must).
 */
#ifdef TRACE_FMGR_PTR
#define	FMGR_PTR2(FP, FID, ARG1, ARG2) \
	fmgr_ptr(FP, FID, 2, ARG1, ARG2)
#else
#define	FMGR_PTR2(FP, FID, ARG1, ARG2) \
	((FP) ? (*((func_ptr)(FP)))(ARG1, ARG2) : fmgr(FID, ARG1, ARG2))
#endif

/*
 *	Flags for the builtin oprrest selectivity routines.
 */
#define	SEL_CONSTANT 	1	/* constant does not vary (not a parameter) */
#define	SEL_RIGHT	2 	/* constant appears to right of operator */

FuNkYfMgRsTuFf
awk '{ print $2, $1; }' $RAWFILE | \
tr '[a-z]' '[A-Z]' | \
sed -e 's/^/#define F_/' >> $HFILE
cat >> $HFILE <<FuNkYfMgRsTuFf

#endif	/* !defined(FMgrIncluded) */
FuNkYfMgRsTuFf

#
# Generate fmgr function table file.
#
# Print out the bogus function declarations, then the table that
# refers to them.
#
cat > $TABCFILE <<FuNkYfMgRtAbStUfF
/*----------------------------------------------------------------
 *   FILE
 *	$TABCFILE
 *
 *   DESCRIPTION
 *	The function manager's table of internal functions.
 *
 *   NOTES
 *
 *	******************************
 *	*** DO NOT EDIT THIS FILE! ***
 *	******************************
 *
 *	It has been GENERATED by $0
 *	from $1
 *
 *	We lie here to cc about the return type and arguments of the
 *	builtin functions; all ld cares about is the fact that it
 *	will need to resolve an external function reference.
 *
 *   IDENTIFICATION
 *	\$Header: /usr/local/devel/postgres/src/backend/utils/RCS/Gen_fmgrtab.sh,v 1.3 1993/01/09 02:49:20 aoki Exp $
 *----------------------------------------------------------------
 */

#include <values.h>		/* for MAXINT */

#include "utils/fmgrtab.h"

RcsId("\$Header: /usr/local/devel/postgres/src/backend/utils/RCS/Gen_fmgrtab.sh,v 1.3 1993/01/09 02:49:20 aoki Exp $");

FuNkYfMgRtAbStUfF
awk '{ print "extern char *" $2 "();"; }' $RAWFILE >> $TABCFILE
cat >> $TABCFILE <<FuNkYfMgRtAbStUfF

static FmgrCall fmgr_builtins[] = {
FuNkYfMgRtAbStUfF
awk '{ print "	{", $1 ",", $8 ",", $2, "},"; }' $RAWFILE >> $TABCFILE
cat >> $TABCFILE <<FuNkYfMgRtAbStUfF
	/* guardian value */
	{ MAXINT, 0, (func_ptr) NULL }
};

static int fmgr_nbuiltins = (sizeof(fmgr_builtins) / sizeof(FmgrCall)) - 1;

FmgrCall *
fmgr_isbuiltin(id)
	ObjectId	id;
{
	register int	i;
	int		low = 0;
	int		high = fmgr_nbuiltins;

	low = 0;
	high = fmgr_nbuiltins;
	while (low <= high) {
		i = low + (high - low) / 2;
		if (id == fmgr_builtins[i].proid)
			break;
		else if (id > fmgr_builtins[i].proid)
			low = i + 1;
		else
			high = i - 1;
	}
	if (id == fmgr_builtins[i].proid)
		return(&fmgr_builtins[i]);
	return((FmgrCall *) NULL);
}
FuNkYfMgRtAbStUfF

rm -f $RAWFILE

# ----------------
#	all done
# ----------------
exit 0
