#include <rpc/rpc.h>
#include "mount.h"


bool_t
xdr_fhandle(xdrs, objp)
	XDR *xdrs;
	fhandle *objp;
{
	if (!xdr_opaque(xdrs, objp->data, FHSIZE)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_fhstatus(xdrs, objp)
	XDR *xdrs;
	fhstatus *objp;
{
	if (!xdr_u_int(xdrs, &objp->fhs_status)) {
		return (FALSE);
	}
	switch (objp->fhs_status) {
	case 0:
		if (!xdr_fhandle(xdrs, &objp->fhstatus_u.fhs_fhandle)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}




bool_t
xdr_dirpath(xdrs, objp)
	XDR *xdrs;
	dirpath *objp;
{
	if (!xdr_string(xdrs, objp, MNTPATHLEN)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_name(xdrs, objp)
	XDR *xdrs;
	name *objp;
{
	if (!xdr_string(xdrs, objp, MNTNAMLEN)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mountlist(xdrs, objp)
	XDR *xdrs;
	mountlist *objp;
{
	if (!xdr_name(xdrs, &objp->ml_hostname)) {
		return (FALSE);
	}
	if (!xdr_dirpath(xdrs, &objp->ml_directory)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->ml_next, sizeof(mountlist), xdr_mountlist)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_groups(xdrs, objp)
	XDR *xdrs;
	groups *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct groupnode), xdr_groupnode)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_groupnode(xdrs, objp)
	XDR *xdrs;
	groupnode *objp;
{
	if (!xdr_name(xdrs, &objp->gr_name)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->gr_next, sizeof(groups), xdr_groups)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_exports(xdrs, objp)
	XDR *xdrs;
	exports *objp;
{
	if (!xdr_dirpath(xdrs, &objp->ex_dir)) {
		return (FALSE);
	}
	if (!xdr_groups(xdrs, &objp->ex_groups)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->ex_next, sizeof(exports), xdr_exports)) {
		return (FALSE);
	}
	return (TRUE);
}


