#!/bin/sh
# $Header: /usr/local/devel/postgres/src/regress/video/RCS/wholevideo.sh,v 1.4 1993/01/09 01:31:19 aoki Exp $
# This is a simple script used to run the entire video without having to
# type all of those tedious include commands to the terminal monitor.
# This script assumes that the postmaster is currently running.
# 
# NOTE:
# It also assumes that you don't have a data base video in which you keep
# important data (it destroys video if it exists then re-creates it to run
# the postgres video queries).
if [ -d ./obj ]; then
	cd ./obj
fi

echo =============== destroying old video database... =================
destroydb video

echo =============== creating new video database... =================
createdb video
if [ $? -ne 0 ]; then
	echo createdb failed
	exit 1
fi

echo =============== running video queries... =================
monitor video < video.pq
if [ $? -ne 0 ]; then
	echo video failed
	exit 1
fi

echo =============== destroying video database... =================
destroydb video
if [ $? -ne 0 ]; then
	echo destroydb failed
	exit 1
fi

exit 0
