#!/bin/sh
# $HEADER:
# 
# wisconsin.sh - populates and runs the wisconsin benchmark on a database
# named "bench".
#

if (test ! -z "$POSTGRESHOME")
then
    PGHOME=$POSTGRESHOME
else
    PGHOME=/usr/postgres
fi

POSTGRES=$PGHOME/bin/postgres
POSTMASTER=$PGHOME/bin/postmaster
CREATEDB=$PGHOME/bin/createdb.sh
VCONTROL=$PGHOME/bin/vcontrol
MAKE=/bin/make

echo ===== creating benchmark database ======

$CREATEDB bench

echo ===== populating initial classes ======

for i in querycreat querycopy querydefineindex queryBprime
do
    echo Running $i....
    $POSTGRES -Q bench < $i > /dev/null
done

echo ===== vacuuming bench database ======
echo "vacuum" | $POSTGRES -Q bench > /dev/null

echo done 
