#!/bin/sh

# $Header: RCS/wholedemo.sh,v 1.2 91/11/19 18:21:43 mer Exp $
# This is a simple script used to run the entire demo without having to
# type all of those tedious include commands to the terminal monitor.
# This script assumes that the postmaster is currently running.
# 
# NOTE:
# It also assumes that you don't have a data base demo in which you keep
# important data (it destroys demo if it exists then re-creates it to run
# the postgres demo queries).

datafile=/tmp/pgdemo.$$

if [ -d $POSTGRESHOME/data/base/demo ]
then
	echo =============== destroying old demo database... =================
	destroydb demo
fi

echo =============== creating new demo database... =================
$POSTGRESHOME/bin/createdb demo

rm -f $datafile

echo "retrieve (x=1) \g" > $datafile

for f in `cat demo_order`
do
	cat $POSTGRESHOME/demo/$f >> $datafile
done


$POSTGRESHOME/bin/monitor demo < $datafile

rm -f $datafile
