#------------
#
# compilation rules for generation of dependencies
#
# - needs the variables 
#   CFLAGS, DFLAGS
#   to be correctly set in the main-body makefile {postgres,support}.mk
#
# $Header: RCS/depends.mk,v 1.1 90/08/03 15:23:01 cimarron Exp $
#------------

.SUFFIXES: .lex .c .d
.c.d:
	@ echo collecting dependencies for $< | /bin/sed -e 's:$(OD)/::' ; \
	trap 'rm -f `basename $(<F) .c`.d; exit' 2 ; \
	/bin/cc -M $(CFLAGS) $(DFLAGS) -c $< | \
	sort -u | \
	/bin/sed -e 's:^:$(<D)/:' \
		 -e 's:$(SD)/:$$(SD)/:g' \
		 -e 's:$(OD)/:$$(OD)/:g' > $(@D)/`basename $(<F) .c`.d

.lex.d:
	@- echo lexing $(<F) ; \
	trap 'rm -f lex.yy.c `basename $(<F)`.c' `basename $(<F)`.d' 2 ; \
	cd $(@D) ; lex $(<F) ; \
	if [ -f lex.sed ] ; then \
		echo "sed'ing lex.yy.c" ; \
		/bin/sed -f lex.sed < lex.yy.c > `basename $(<F) .lex`.c; \
	else \
		mv lex.yy.c `basename $(<F) .lex`.c ; \
	fi ; \
	/bin/cc -M $(CFLAGS) $(DFLAGS) -c `basename $(<F) .lex`.c ; \
	sort -u | \
	/bin/sed -e 's:^:$(<D)/:' \
		 -e 's:$(SD)/:$$(SD)/:g' \
		 -e 's:$(OD)/:$$(OD)/:g' > `basename $(<F) .lex`.d ; \
	rm -f `basename $(<F) .lex`.c 
	
