#! /bin/sh
#
#	Gen_accessors -- Create accessor functions for nodes.
#
#	$Header: RCS/Gen_accessors.sprite.sh,v 1.2 90/08/23 01:23:41 choi Exp $
#

# ----------------
# 	initial definitions
# ----------------
CAT=/bin/cat
CB=/usr/bin/cb
CPP=/lib/cpp
EGREP=/usr/bin/egrep
RM=/bin/rm
SED=/bin/sed
SEDTMP=/tmp/sedtmp.$$
CTMP1=/tmp/ctmp1.$$
SRC=$1

# ----------------
# 	set up some necessary input files
# ----------------
$CAT > $SEDTMP << 'EOF'
/\/\*/,/\*\//D
/[ 	][ 	]*/s// /g
/^class/ {
	i\
#undef XXXXXX
	s/class (\([A-Za-z_][A-Za-z0-9_]*\)).*/#define XXXXXX \1/
}
s/^ \([A-Za-z_][A-Za-z0-9_]*\) \([A-Za-z_][A-Za-z0-9_]*\)[; \\]*$/ACCESSORS(XXXXXX,\2,\1)/
s/^ \([A-Za-z_][A-Za-z0-9_ ]*\) \(\*\)\([A-Za-z_][A-Za-z0-9_]*\)[; \\]*$/ACCESSORS(XXXXXX,\3,\1 \2)/
EOF

# ----------------
#       set up CTMP1 for SPRITE OS
#       this was neccessary because sprite uses gnu cpp.
#	#define for CppConcat had to be changed.
# ----------------
$CAT > $CTMP1 << 'EOF'
#define CppIdentity(a)a
#define CppConcat(a,b)a/**/b

#define ACCESSORS(_nodetype_,_fieldname_,_fieldtype_) \
extern void CppConcat(set_,_fieldname_) ARGS((_nodetype_ node, _fieldtype_ value)); \
void \
CppConcat(set_,_fieldname_)(node, value) \
        _nodetype_      node; \
        _fieldtype_     value; \
{ \
        NODEAssertArg(IsA(node,_nodetype_)); \
        node->_fieldname_ = value; \
} \
extern _fieldtype_ CppConcat(get_,_fieldname_) ARGS((_nodetype_ node)); \
_fieldtype_ \
CppConcat(get_,_fieldname_)(node) \
        _nodetype_      node; \
{ \
        NODEAssertArg(IsA(node,_nodetype_)); \
        return(node->_fieldname_); \
} \
EOF

# ----------------
# 	do the actual work
# ----------------

echo "/* ---------------------------------------------------------------- "
echo " * 	node file generated from $SRC"
echo " * "
echo " * 	this file has been generated by the Gen_accessors.sh"
echo " * 	and Gen_creator.sh scripts as part of the initial node"
echo " * 	generation process."
echo " * ---------------------------------------------------------------- "
echo " */"
echo "#include \"$SRC\""
echo " "
echo "#ifdef NO_NODE_CHECKING"
echo "#define NODEAssertArg(x)"
echo "#else"
echo "#define NODEAssertArg(x)	AssertArg(x)"
echo "#endif NO_NODE_CHECKING"
echo " "

# -traditional option added for SPRITE OS
# this makes gnu cpp act like regular cpp.

$EGREP -v '(^#|^[ 	/]*\*|typedef|Defs|inherits|})' < $SRC | \
$SED -f $SEDTMP | \
$CAT $CTMP1 - | \
$CPP -P -traditional | \
$SED 's/T_ /T_/' | \
$CB | \
$EGREP -v '^$'

$RM -f $SEDTMP $HTMP1 $CTMP1

