/*
 * linval.h --
 *	POSTGRES local cache invalidation definitions.
 *
 * Identification:
 *	$Header: RCS/linval.h,v 1.6 90/08/18 00:40:58 cimarron Exp $
 */

#ifndef	LInvalIncluded	/* Include this file only once */
#define LInvalIncluded	1

#include "tmp/postgres.h"

typedef struct InvalidationUserData {
	struct InvalidationUserData	*dataP[1];	/* VARIABLE LENGTH */
} InvalidationUserData;	/* VARIABLE LENGTH STRUCTURE */

typedef struct InvalidationEntryData {
	InvalidationUserData	*nextP;
	InvalidationUserData	userData;	/* VARIABLE LENGTH ARRAY */
} InvalidationEntryData;	/* VARIABLE LENGTH STRUCTURE */

typedef Pointer InvalidationEntry;

typedef InvalidationEntry	LocalInvalid;

#define EmptyLocalInvalid	NULL

/*
 * InvalididationEntryAllocate --
 *	Allocates an invalidation entry.
 */
InvalidationEntry
InvalidationEntryAllocate ARGS((
	uint16	size
));

/*
 * LocalInvalidRegister --
 *	Returns a new local cache invalidation state containing a new entry.
 */
extern
LocalInvalid
LocalInvalidRegister ARGS((
	LocalInvalid		invalid,
	InvalidationEntry	entry
));

/*
 * LocalInvalidInvalidate --
 *	Processes, then frees all entries in a local cache invalidation state.
 */
extern
void
LocalInvalidInvalidate ARGS((
	LocalInvalid	invalid,
	void		(*function)(
		InvalidationEntry	entry
	)
));

#endif	/* !defined(LInvalIncluded) */
