/*
 * pagenum.c --
 *	POSTGRES page number code.
 *
 * related to internal_page.h, not internal.h
 */

#include "tmp/c.h"
#include "storage/part.h"
#include "storage/pagenum.h"

RcsId("$Header: RCS/pagenum.c,v 1.5 90/09/25 16:46:39 kemnitz Exp $");

bool
PageNumberIsValid(pageNumber, partition)
	PageNumber	pageNumber;
	PagePartition	partition;
{
	return ((bool)(pageNumber < PagePartitionGetPagesPerBlock(partition)));
}


bool
LogicalPageNumberIsValid(pageNumber)
	LogicalPageNumber	pageNumber;
{
	return ((bool)(pageNumber != InvalidLogicalPageNumber));
}
