# ----------------------------------------------------------------
#    Makefile for POSTGRES test buffer manager code
#
#	$Header: RCS/buf.mk,v 1.2 89/09/05 16:54:01 mao Version_2 $
# ----------------------------------------------------------------

# ----------------
#    conf.local contains all the configuration definitions
# ----------------

#include "conf.local"

# ----------------
#    test buffer manager settings
# ----------------

TESTBUF		=	$(DATAHOME)/bin/amiint
SCRDIR		=	$(DATAHOME)/src/test

DFLAGS		=	-DDATAHOME='"$(DATAHOME)"'

BUFIFLAGS	=	-I$(OBJDIR)/storage/buffer

IFLAGS		=	-I$(HDRDIR)

CFLAGS		=	-O $(IFLAGS)

LIBS		=	-lm -ll

# ----------------
#    port.mk contains port-specific information, including
#    PORTSRCDIR and PORTOBJDIR
# ----------------

#include "CONF/port.mk"

# ----------------
#    Definition of search paths
# ----------------

PMAKE_VPATH_SRCS ?=	./ \
			$(SRCDIR)/$(LISPLIB) \
			$(SRCDIR)/access/genam \
			$(SRCDIR)/access/heap \
			$(SRCDIR)/access/index-btree \
			$(SRCDIR)/access/spam \
			$(SRCDIR)/access/tuple \
			$(SRCDIR)/commands \
			$(SRCDIR)/lib/C \
			$(SRCDIR)/lib/libpq \
			$(SRCDIR)/lib/libpq/demo \
			$(SRCDIR)/lib/libpqcl \
			$(SRCDIR)/lib/catalog \
			$(SRCDIR)/parser \
			$(SRCDIR)/storage/buffer \
			$(SRCDIR)/storage/ipc \
			$(SRCDIR)/storage/lmgr \
			$(SRCDIR)/storage/page \
			$(SRCDIR)/storage/file \
			$(SRCDIR)/support \
			$(SRCDIR)/test \
			$(SRCDIR)/utils/adt \
			$(SRCDIR)/utils/cache \
			$(SRCDIR)/utils/fmgr \
			$(SRCDIR)/utils/init \
			$(SRCDIR)/utils/mmgr \
			$(SRCDIR)/utils/error \
			$(SRCDIR)/utils/comm \
			$(SRCDIR)/utils/xact \
			$(SRCDIR)/utils/time \
			$(SRCDIR)/utils/rules

PMAKE_VPATH_HDRS ?=	./ $(SRCDIR) $(HDRDIR)

PMAKE_VPATH_OBJS ?=	./ \
			$(OBJDIR)/$(LISPLIB) \
			$(OBJDIR)/access/genam \
			$(OBJDIR)/access/heap \
			$(OBJDIR)/access/index-btree \
			$(OBJDIR)/access/spam \
			$(OBJDIR)/access/tuple \
			$(OBJDIR)/commands \
			$(OBJDIR)/lib/C \
			$(OBJDIR)/lib/libpq \
			$(OBJDIR)/lib/libpq/demo \
			$(OBJDIR)/lib/libpqcl \
			$(OBJDIR)/lib/catalog \
			$(OBJDIR)/parser \
			$(OBJDIR)/storage/buffer \
			$(OBJDIR)/storage/ipc \
			$(OBJDIR)/storage/lmgr \
			$(OBJDIR)/storage/page \
			$(OBJDIR)/storage/file \
			$(OBJDIR)/support \
			$(OBJDIR)/test \
			$(OBJDIR)/utils/adt \
			$(OBJDIR)/utils/cache \
			$(OBJDIR)/utils/fmgr \
			$(OBJDIR)/utils/init \
			$(OBJDIR)/utils/mmgr \
			$(OBJDIR)/utils/error \
			$(OBJDIR)/utils/comm \
			$(OBJDIR)/utils/xact \
			$(OBJDIR)/utils/time \
			$(OBJDIR)/utils/rules

# ----------------
#    Definition of sources
# ----------------

#
# local test files
#

LOCALSRCS=	testinit.c

LOCALOBJS=	$(LOCALSRCS:S/.c/.o/g)

#
# test buffer manager files
#

BUFSRCS=	testbuf.c
BUFOBJS=	$(BUFSRCS:S/.c/.o/g)

#
# sources of targets
#

TARGETSRCS=	createdb.c

#
# special sources
#

SPECIALSRCS=	elog.c \
		fmgr.c \
		syscache.c

SPECIALOBJS=	$(SPECIALSRCS:S/.c/.o/g)

SPECIALFLAGS=	-DPG_STANDALONE $(DFLAGS)

# ----------------
#   absolute paths to objects until something better can be done
# ----------------

access.o=		$(OBJDIR)/access/heap/access.o
#	ami.h=			ami.h
#	ami_parser.o=		ami_parser.o
assert.o=		$(OBJDIR)/utils/error/assert.o
att.o=			$(OBJDIR)/access/tuple/att.o
attnum.o=		$(OBJDIR)/access/tuple/attnum.o
attval.o=		$(OBJDIR)/access/tuple/attval.o
bit.o=			$(OBJDIR)/lib/C/bit.o
block.o=		$(OBJDIR)/storage/page/block.o
bool.o=			$(OBJDIR)/utils/adt/bool.o
btdata.o=		$(OBJDIR)/access/index-btree/btdata.o
bthacks.o=		$(OBJDIR)/access/index-btree/bthacks.o
bthdr.o=		$(OBJDIR)/access/index-btree/bthdr.o
btinsrt.o=		$(OBJDIR)/access/index-btree/btinsrt.o
btitem.o=		$(OBJDIR)/access/index-btree/btitem.o
btkey.o=		$(OBJDIR)/access/index-btree/btkey.o
btlock.o=		$(OBJDIR)/access/index-btree/btlock.o
btnode.o=		$(OBJDIR)/access/index-btree/btnode.o
btpage.o=		$(OBJDIR)/access/index-btree/btpage.o
btqual.o=		$(OBJDIR)/access/index-btree/btqual.o
btree.o=		$(OBJDIR)/access/index-btree/btree.o
btscan.o=		$(OBJDIR)/access/index-btree/btscan.o
btsrch.o=		$(OBJDIR)/access/index-btree/btsrch.o
btstk.o=		$(OBJDIR)/access/index-btree/btstk.o
btstrat.o=		$(OBJDIR)/access/index-btree/btstrat.o
buf.o=			$(OBJDIR)/storage/buffer/buf.o
buf_sync.o=		$(OBJDIR)/storage/buffer/buf_sync.o
bufmgr.o=		$(OBJDIR)/storage/buffer/bufmgr.o
bufpage.o=		$(OBJDIR)/storage/page/bufpage.o
catalog.o=		$(OBJDIR)/lib/catalog/catalog.o
catcache.o=		$(OBJDIR)/utils/cache/catcache.o
catname.o=		$(OBJDIR)/lib/catalog/catname.o
char.o=			$(OBJDIR)/utils/adt/char.o
cinit.o=		$(OBJDIR)/utils/init/cinit.o
context.o=		$(OBJDIR)/utils/mmgr/context.o
create.o=		$(OBJDIR)/access/heap/create.o
creati.o=		$(OBJDIR)/access/genam/creati.o
date.o=			$(OBJDIR)/utils/adt/date.o
datum.o=		$(OBJDIR)/utils/adt/datum.o
defind.o=		$(OBJDIR)/commands/defind.o
dlog.o=			$(OBJDIR)/utils/error/dlog.o
dt.o=			$(OBJDIR)/utils/adt/dt.o
elog.o=			elog.o
fd.o=			$(OBJDIR)/storage/file/fd.o
float.o=		$(OBJDIR)/utils/adt/float.o
fmgr.o=			fmgr.o
form.o=			$(OBJDIR)/access/tuple/form.o
format.o=		$(OBJDIR)/utils/error/format.o
ftree-am.o=		$(OBJDIR)/access/index-ftree/ftree-am.o
ftree-util.o=		$(OBJDIR)/access/index-ftree/ftree-util.o
ftup.o=			$(OBJDIR)/access/tuple/ftup.o
genam.o=		$(OBJDIR)/access/genam/genam.o
geo-ops.o=		$(OBJDIR)/utils/adt/geo-ops.o
geo-selfuncs.o=		$(OBJDIR)/utils/adt/geo-selfuncs.o
hash.o=			$(OBJDIR)/lib/C/hash.o
hashlib.o=		$(OBJDIR)/lib/C/hashlib.o
heapam.o=		$(OBJDIR)/access/heap/heapam.o
hio.o=			$(OBJDIR)/access/heap/hio.o
hrnd.o=			$(OBJDIR)/access/heap/hrnd.o
htup.o=			$(OBJDIR)/access/tuple/htup.o
imark.o=		$(OBJDIR)/storage/buffer/imark.o
initspam.o=		$(OBJDIR)/access/spam/initspam.o
int.o=			$(OBJDIR)/utils/adt/int.o
inval.o=		$(OBJDIR)/utils/cache/inval.o
ipc.o=			$(OBJDIR)/storage/ipc/ipc.o
ipci.o=			$(OBJDIR)/storage/ipc/ipci.o
iqual.o=		$(OBJDIR)/access/genam/iqual.o
isop.o=			$(OBJDIR)/access/genam/isop.o
istrat.o=		$(OBJDIR)/access/genam/istrat.o
itemid.o=		$(OBJDIR)/storage/page/itemid.o
itemptr.o=		$(OBJDIR)/storage/page/itemptr.o
#	Pitemptr.o=		itemptr.o
itup.o=			$(OBJDIR)/access/tuple/itup.o
kw.o=			$(OBJDIR)/access/index-ftree/kw.o
kwlist.o=		$(OBJDIR)/access/index-ftree/kwlist.o
kwlistsel.o=		$(OBJDIR)/access/index-ftree/kwlistsel.o
kwsel.o=		$(OBJDIR)/access/index-ftree/kwsel.o
linval.o=		$(OBJDIR)/utils/cache/linval.o
lmgr.o=			$(OBJDIR)/storage/lmgr/lmgr.o
log-blocktuple.o=	$(OBJDIR)/access/spam/log-blocktuple.o
log-primitives.o=	$(OBJDIR)/access/spam/log-primitives.o
magic.o=		$(OBJDIR)/utils/init/magic.o
mmgr.o=			$(OBJDIR)/utils/mmgr/mmgr.o
name.o=			$(OBJDIR)/utils/adt/name.o
newam.o=		$(OBJDIR)/access/genam/newam.o
#	nullbufmgr.o=		nullbufmgr.o
numutils.o=		$(OBJDIR)/utils/adt/numutils.o
#	oamiint.o=		oamiint.o
off.o=			$(OBJDIR)/storage/page/off.o
oid.o=			$(OBJDIR)/utils/adt/oid.o
order.o=		$(OBJDIR)/storage/buffer/order.o
page.o=			$(OBJDIR)/storage/page/page.o
pagenum.o=		$(OBJDIR)/storage/page/pagenum.o
part.o=			$(OBJDIR)/storage/page/part.o
pcomm.o=		$(OBJDIR)/utils/comm/pcomm.o
pladt.o=		$(OBJDIR)/storage/lmgr/pladt.o
pladtdeb.o=		$(OBJDIR)/storage/lmgr/pladtdeb.o
pldebug.o=		$(OBJDIR)/storage/lmgr/pldebug.o
plm.o=			$(OBJDIR)/storage/lmgr/plm.o
plsync.o=		$(OBJDIR)/storage/lmgr/plsync.o
pos.o=			$(OBJDIR)/storage/page/pos.o
#	postmaster.o=		postmaster.o
pskip.o=		$(OBJDIR)/storage/page/pskip.o
rac.o=			$(OBJDIR)/access/heap/rac.o
regproc.o=		$(OBJDIR)/utils/adt/regproc.o
rel.o=			$(OBJDIR)/access/genam/rel.o
relcache.o=		$(OBJDIR)/utils/cache/relcache.o
sdir.o=			$(OBJDIR)/access/genam/sdir.o
selfuncs.o=		$(OBJDIR)/utils/adt/selfuncs.o
simplelists.o=		$(OBJDIR)/lib/C/simplelists.o
sinval.o=		$(OBJDIR)/storage/ipc/sinval.o
sinvaladt.o=		$(OBJDIR)/storage/ipc/sinvaladt.o
skey.o=			$(OBJDIR)/access/genam/skey.o
spam-accessors.o=	$(OBJDIR)/access/spam/spam-accessors.o
spam-control.o=		$(OBJDIR)/access/spam/spam-control.o
spam-debug.o=		$(OBJDIR)/access/spam/spam-debug.o
spam-index.o=		$(OBJDIR)/access/spam/spam-index.o
spam-mmgr.o=		$(OBJDIR)/access/spam/spam-mmgr.o
spam-primitives.o=	$(OBJDIR)/access/spam/spam-primitives.o
spam-utils.o=		$(OBJDIR)/access/spam/spam-utils.o
syscache.o=		syscache.o
testbuf.o=		testbuf.o
testinit.o=		testinit.o
tim.o=			$(OBJDIR)/utils/adt/tim.o
time-blocktuple.o=	$(OBJDIR)/access/spam/time-blocktuple.o
time-dirtuple.o=	$(OBJDIR)/access/spam/time-dirtuple.o
time-primitives.o=	$(OBJDIR)/access/spam/time-primitives.o
tqual.o=		$(OBJDIR)/utils/time/tqual.o
trange.o=		$(OBJDIR)/utils/time/trange.o
tuple.o=		$(OBJDIR)/access/tuple/tuple.o
utils.o=		$(OBJDIR)/commands/utils.o
valid.o=		$(OBJDIR)/access/genam/valid.o
var-access.o=		$(OBJDIR)/access/spam/var-access.o
varlena.o=		$(OBJDIR)/utils/adt/varlena.o
xcxt.o=			$(OBJDIR)/utils/xact/xcxt.o
xid.o=			$(OBJDIR)/utils/xact/xid.o
xlog.o=			$(OBJDIR)/utils/xact/xlog.o
xstate.o=		$(OBJDIR)/utils/xact/xstate.o
xtim.o=			$(OBJDIR)/utils/xact/xtim.o

#
# generalized sources
#

SOURCES=	$(LOCALSRCS) \
		$(SPECIALSRCS) \
		$(TARGETSRCS)

#
# access method objs
#

GENAMOBJS= \
	$(access.o) \
	$(assert.o) \
	$(att.o) \
	$(attnum.o) \
	$(attval.o) \
	$(bit.o) \
	$(block.o) \
	$(bool.o) \
	$(btdata.o) \
	$(bthacks.o) \
	$(bthdr.o) \
	$(btinsrt.o) \
	$(btitem.o) \
	$(btkey.o) \
	$(btlock.o) \
	$(btnode.o) \
	$(btpage.o) \
	$(btqual.o) \
	$(btree.o) \
	$(btscan.o) \
	$(btsrch.o) \
	$(btstk.o) \
	$(btstrat.o) \
	$(buf.o) \
	$(bufmgr.o) \
	$(bufpage.o) \
	$(buf_sync.o) \
	$(catalog.o) \
	$(catcache.o) \
	$(catname.o) \
	$(char.o) \
	$(cinit.o) \
	$(context.o) \
	$(create.o) \
	$(creati.o) \
	$(date.o) \
	$(datum.o) \
	$(defind.o) \
	$(dlog.o) \
	$(dt.o) \
	$(elog.o) \
	$(fd.o) \
	$(float.o) \
	$(fmgr.o) \
	$(form.o) \
	$(format.o) \
	$(ftree-am.o) \
	$(ftree-util.o) \
	$(ftup.o) \
	$(genam.o) \
	$(geo-ops.o) \
	$(geo-selfuncs.o) \
	$(hash.o) \
	$(hashlib.o) \
	$(heapam.o) \
	$(hio.o) \
	$(hrnd.o) \
	$(htup.o) \
	$(imark.o) \
	$(initspam.o) \
	$(int.o) \
	$(inval.o) \
	$(ipc.o) \
	$(ipci.o) \
	$(iqual.o) \
	$(isop.o) \
	$(istrat.o) \
	$(itemid.o) \
	$(itemptr.o) \
	$(itup.o) \
	$(kw.o) \
	$(kwlist.o) \
	$(kwlistsel.o) \
	$(linval.o) \
	$(lmgr.o) \
	$(log-blocktuple.o) \
	$(log-primitives.o) \
	$(magic.o) \
	$(mmgr.o) \
	$(name.o) \
	$(newam.o) \
	$(numutils.o) \
	$(off.o) \
	$(oid.o) \
	$(order.o) \
	$(page.o) \
	$(pagenum.o) \
	$(part.o) \
	$(pcomm.o) \
	$(pladt.o) \
	$(pladtdeb.o) \
	$(pldebug.o) \
	$(plm.o) \
	$(plsync.o) \
	$(pos.o) \
	$(pskip.o) \
	$(rac.o) \
	$(regproc.o) \
	$(rel.o) \
	$(relcache.o) \
	$(sdir.o) \
	$(selfuncs.o) \
	$(simplelists.o) \
	$(sinval.o) \
	$(sinvaladt.o) \
	$(skey.o) \
	$(spam-accessors.o) \
	$(spam-control.o) \
	$(spam-debug.o) \
	$(spam-index.o) \
	$(spam-mmgr.o) \
	$(spam-primitives.o) \
	$(spam-utils.o) \
	$(syscache.o) \
	$(tim.o) \
	$(time-blocktuple.o) \
	$(time-dirtuple.o) \
	$(time-primitives.o) \
	$(tqual.o) \
	$(trange.o) \
	$(tuple.o) \
	$(valid.o) \
	$(var-access.o) \
	$(varlena.o) \
	$(xcxt.o) \
	$(xid.o) \
	$(xlog.o) \
	$(xstate.o) \
	$(xtim.o)

#
# target objs
#

TESTBUFOBJS= \
	$(GENAMOBJS) \
	$(LOCALOBJS)

#---------
# on pain of death, do not include $(GENAMOBJS)
# $(NAMIINTOBJS) , $(AMIINTOBJS) $(DESTROYDBOBJS)
# $(DUMPBPAGESOBJS)
# to the list below
#-----------
OBJS= $(LOCALOBJS) $(LOCALPMOBJS) $(CREATEDBOBJS) \
	$(AMIOBJS)

ALL=	testbuf


stdout		?=	/dev/tty

# ----------------
#    default.mk contains standard make information like
#    transformation rules, what compiler to use, etc.
# ----------------

#include "CONF/default.mk"

# ----------------
#    targets
# ----------------

.MAIN:	Main

Main:	$(ALL)

testbuf: $(START) $(testbuf.o) $(TESTBUFOBJS)
	$(cc) -o $(.TARGET) $(.ALLSRC) $(LIBS)
	$(chmod) $(BINMODE) $(.TARGET)


# ----------------
#
# ----------------

elog.o: $(START) elog.c
	$(cc) $(SPECIALFLAGS) -c $(.ALLSRC)

fmgr.o: $(START) fmgr.c
	$(cc) $(SPECIALFLAGS) -c $(.ALLSRC)

syscache.o: $(START) syscache.c
	$(cc) $(SPECIALFLAGS) -c $(.ALLSRC)

# ----------------
#
# ----------------

install:: $(START)  \
		$(BINDIR)/testbuf

$(BINDIR)/testbuf: $(START) testbuf
	$(cp) $(.TARGET:T) $(.TARGET)
	$(chmod) $(BINMODE) $(.TARGET)

FOO1OBJS= \
	$(access.o) \
	$(assert.o) \
	$(att.o) \
	$(attnum.o) \
	$(attval.o) \
	$(bit.o) \
	$(block.o) \
	$(bool.o) \
	$(btdata.o) \
	$(bthacks.o) \
	$(bthdr.o) \
	$(btinsrt.o) \
	$(btitem.o) \
	$(btkey.o) \
	$(btlock.o) \
	$(btnode.o)

FOO2OBJS= \
	$(btpage.o) \
	$(btqual.o) \
	$(btree.o) \
	$(btscan.o) \
	$(btsrch.o) \
	$(btstk.o) \
	$(btstrat.o) \
	$(buf.o) \
	$(bufmgr.o) \
	$(bufpage.o) \
	$(buf_sync.o) \
	$(catalog.o) \
	$(catcache.o) \
	$(catname.o) \
	$(char.o) \
	$(cinit.o)

FOO3OBJS= \
	$(context.o) \
	$(create.o) \
	$(creati.o) \
	$(date.o) \
	$(datum.o) \
	$(defind.o) \
	$(dlog.o) \
	$(dt.o) \
	$(elog.o) \
	$(fd.o) \
	$(float.o) \
	$(fmgr.o) \
	$(form.o) \
	$(format.o) \
	$(ftree-am.o) \
	$(ftree-util.o)

FOO4OBJS= \
	$(ftup.o) \
	$(genam.o) \
	$(geo-ops.o) \
	$(geo-selfuncs.o) \
	$(hash.o) \
	$(hashlib.o) \
	$(heapam.o) \
	$(hio.o) \
	$(hrnd.o) \
	$(htup.o) \
	$(imark.o) \
	$(initspam.o) \
	$(int.o) \
	$(inval.o) \
	$(ipc.o) \
	$(ipci.o)

FOO5OBJS= \
	$(iqual.o) \
	$(isop.o) \
	$(istrat.o) \
	$(itemid.o) \
	$(itemptr.o) \
	$(itup.o) \
	$(kw.o) \
	$(kwlist.o) \
	$(kwlistsel.o) \
	$(linval.o) \
	$(lmgr.o) \
	$(log-blocktuple.o) \
	$(log-primitives.o) \
	$(magic.o) \
	$(mmgr.o) \
	$(name.o)

FOO6OBJS= \
	$(newam.o) \
	$(numutils.o) \
	$(off.o) \
	$(oid.o) \
	$(order.o) \
	$(page.o) \
	$(pagenum.o) \
	$(part.o) \
	$(pcomm.o) \
	$(pladt.o) \
	$(pladtdeb.o) \
	$(pldebug.o) \
	$(plm.o) \
	$(plsync.o) \
	$(pos.o) \
	$(pskip.o)

FOO7OBJS= \
	$(rac.o) \
	$(regproc.o) \
	$(rel.o) \
	$(relcache.o) \
	$(sdir.o) \
	$(selfuncs.o) \
	$(simplelists.o) \
	$(sinval.o) \
	$(sinvaladt.o) \
	$(skey.o) \
	$(spam-accessors.o) \
	$(spam-control.o) \
	$(spam-debug.o) \
	$(spam-index.o) \
	$(spam-mmgr.o) \
	$(spam-primitives.o)

FOO8OBJS= \
	$(spam-utils.o) \
	$(syscache.o) \
	$(tim.o) \
	$(time-blocktuple.o) \
	$(time-dirtuple.o) \
	$(time-primitives.o) \
	$(tqual.o) \
	$(trange.o) \
	$(tuple.o) \
	$(valid.o) \
	$(var-access.o) \
	$(varlena.o) \
	$(xcxt.o) \
	$(xid.o) \
	$(xlog.o) \
	$(xstate.o) \
	$(xtim.o)

FOOO=	yylex

foo! .SILENT .IGNORE
	nm -o $(FOO1OBJS) | egrep $(FOOO)
	nm -o $(FOO2OBJS) | egrep $(FOOO)
	nm -o $(FOO3OBJS) | egrep $(FOOO)
	nm -o $(FOO4OBJS) | egrep $(FOOO)
	nm -o $(FOO5OBJS) | egrep $(FOOO)
	nm -o $(FOO6OBJS) | egrep $(FOOO)
	nm -o $(FOO7OBJS) | egrep $(FOOO)
	nm -o $(FOO8OBJS) | egrep $(FOOO)
