static	char	testinit_c[] = "$Header: RCS/testadt.c,v 1.5 90/06/07 18:20:52 cimarron Version_2 $";

#include <sys/file.h>
#include <stdio.h>
#include <setjmp.h>
#ifndef	NODFLT
#include <pwd.h>
#endif
#include <strings.h>
#include "datadir.h"
#include "skey.h"
#include "log.h"

/*
 *	testinit.c	- standard test program shell
 */

struct	context	TopCxt = {
	-1,						/* ct_user */
	-1,						/* ct_xid */
	(char *)NULL,					/* ct_dbappnd */
	(char *)NULL,					/* ct_dbdbappnd */
	DATADIR,					/* ct_datadir */
	DATADIR,					/* ct_dbdbdir */
	0						/* ct_mmgr */
};
struct	context	*Cxt = &TopCxt;

main(argc, argv)
int	argc;
char	*argv[];
{
	int		uid;				/* uid_t */
	int		namelen;
#ifndef	NODFLT
	char		*datname;
	struct	passwd	*pw;
	extern		endpwent();
#endif
	char		s[80], *t, *u;
	char		*path_in();
	char		*path_out();
	extern		pfree();
	extern	int	Err_file;
	extern	int	Debug_file;
	extern	jmp_buf	Warn_restart;
	int		setjmp();
	int		getuid();			/* uid_t */
	int		geteuid();			/* uid_t */
	int		setuid();
	long		time();
	extern		initbuf();
	extern		initmmgr();
	extern		initfmgr();
	extern		resetmmgr();
	extern		bflush();
	extern		elog();

	Debug_file = fileno(stderr);
	Err_file = open("/dev/null", O_WRONLY, 0666);
#ifndef	NODFLT
	if (argc == 1) {
		if ((pw = getpwuid(uid = getuid())) == (struct passwd *)NULL)
			elog(FATAL,
			     "%s: failed getpwuid()",
			     rindex(argv[0], '/') ?
			     rindex(argv[0], '/') + 1 :
			     argv[0]);
		datname = pw->pw_name;
		endpwent();
	} else if (argc == 2)
		datname = argv[1];
	else
		elog(FATAL,
		     "Usage: %s [datname]",
		     rindex(argv[0], '/') ? rindex(argv[0], '/') + 1 : argv[0]);
	namelen = strlen(datname);
#else
	if (argc != 2)
		elog(FATAL,
		     "Usage: %s datname",
		     rindex(argv[0], '/') ? rindex(argv[0], '/') + 1 : argv[0]);
	namelen = strlen(argv[1]);
#endif
	if (!namelen || namelen > 16)
		elog(FATAL, "Database names are limited to 1 to 16 characters");
	/* XXX other checks too */
	TopCxt.ct_user = uid;
	TopCxt.ct_xid = time(0);
	TopCxt.ct_dbappnd = TopCxt.ct_datadir + sizeof (DATADIR) - 1;
	*TopCxt.ct_dbappnd++ = '/';
#ifndef	NODFLT
	bcopy(datname, TopCxt.ct_dbappnd, namelen);
#else
	bcopy(argv[1], TopCxt.ct_dbappnd, namelen);
#endif
	TopCxt.ct_dbappnd += namelen;
	*TopCxt.ct_dbappnd++ = '/';
	TopCxt.ct_dbdbappnd = TopCxt.ct_dbdbdir + sizeof (DATADIR) - 1;
	bcopy("/dbdb/", TopCxt.ct_dbdbappnd, sizeof ("/dbdb/") - 1);
	TopCxt.ct_dbdbappnd += sizeof ("/dbdb/") - 1;
	setuid(geteuid());
	initbuf();
	initmmgr();
	initfmgr();
	if (setjmp(Warn_restart) != NULL) {
		bflush();
		resetmmgr();
	}
	for(;;) {
		puts("Please enter a path (external string representation)");
		scanf("%s", s);
		t = path_in(s);
		printf("Read %s with internal length %d\n", s, PSIZE(t));
		
		printf("The object returned to output form is %s\n", u = path_out(t));
		pfree(t);
		pfree(u);
	}
}
