/*
 * testxid.c --
 *	Transaction id test code.
 */

#include "fmgr.h"	/* for M_STATIC/M_DYNAMIC */

#include <stdio.h>

#include "c.h"

#include "xid.h"

RcsId("$Header: RCS/testxid.c,v 1.3 89/09/05 16:55:09 mao Version_2 $");

TestMain()
{
	char		buffer[80];
	TransactionId	xid;
	int		i;
	static bool	beenHere = false;

	if (beenHere) {
		elog(1 /* FATAL */, "testxid: error occurred");
	} else {
		beenHere = true;
	}
	StartTransactionCommand();

	xid = GetNewTransactionId();

	printf("The \"first\" xid is %s\n", TransactionIdFormString(xid));
	printf("The next twenty xids are");

	for (i = 0; i < 20; i += 1) {
		xid = GetNewTransactionId();
		printf(" %s", TransactionIdFormString(xid));
	}
	printf("\n");

	for (i = 0; i < 3456; i += 1) {
		xid = GetNewTransactionId();
	}
	printf("The 3456th next xid is %s\n", TransactionIdFormString(xid));

	for (;;) {
		printf("Please enter a xid: ");
		if (scanf("%s", buffer) < 1) {
			break;
		}
		xid = StringFormTransactionId(buffer);
		printf("You entered %s\n\n", TransactionIdFormString(xid));
	}
	printf("Done!\n");
}
