/*
 * tim.c --
 *	POSTGRES time code.
 */

#include "tmp/postgres.h"
#include "tmp/miscadmin.h"

RcsId("$Header: RCS/tim.c,v 1.9 91/11/09 01:53:14 mer Exp $");

bool AbsoluteTimeIsBefore ARGS((AbsoluteTime time1 , AbsoluteTime time2 ));
bool AbsoluteTimeIsAfter ARGS((AbsoluteTime time1 , AbsoluteTime time2 ));
bool TimeIsBefore ARGS((Time time1 , Time time2 ));

/*
 *  AbsoluteTimeIsBefore -- true iff time1 is before time2.
 *
 *	Since we store AbsoluteTimes as unsigned quantities, the comparison
 *	below would fail for times before the Unix epoch.  We cast them to
 *	signed quantities for the sake of this comparison, even though it
 *	violates the type-hiding abstraction.
 */

bool
AbsoluteTimeIsBefore(time1, time2)
	AbsoluteTime	time1;
	AbsoluteTime	time2;
{
	Assert(AbsoluteTimeIsValid(time1));
	Assert(AbsoluteTimeIsValid(time2));

	return ((bool)((int32) time1 < (int32) time2));
}

bool
AbsoluteTimeIsAfter(time1, time2)
	AbsoluteTime	time1;
	AbsoluteTime	time2;
{
	Assert(AbsoluteTimeIsValid(time1));
	Assert(AbsoluteTimeIsValid(time2));

	return ((bool) ((int32) time1 > (int32) time2));
}

bool
TimeIsBefore(time1, time2)		/* XXX remove this */
	Time	time1;
	Time	time2;
{
	return (AbsoluteTimeIsBefore(time1, time2));
}
