#!/bin/sh

# $Header: RCS/wholevideo.sh,v 1.2 91/11/20 03:05:48 mer Exp $
# This is a simple script used to run the entire video without having to
# type all of those tedious include commands to the terminal monitor.
# This script assumes that the postmaster is currently running.
# 
# NOTE:
# It also assumes that you don't have a data base video in which you keep
# important data (it destroys video if it exists then re-creates it to run
# the postgres video queries).

datafile=/tmp/pgvideo.$$

if [ -d $POSTGRESHOME/data/base/video ]
then
	echo ===== destroying old video database... =====
	destroydb video
fi

echo ===== creating new video database... =====
$POSTGRESHOME/bin/createdb video

rm -f $datafile

echo "retrieve (x=1) \g" > $datafile

for f in `cat video_order`
do
	cat $POSTGRESHOME/video/$f | sed -e 's/\\p/\\g/g' >> $datafile
done

$POSTGRESHOME/bin/monitor video < $datafile

rm -f $datafile
