#define NETSTAT "/usr/ucb/netstat -n -A"
#define NETSTATBUF 200 /* 80 would suffice */
#define NETSTATREMOTE 49
#define NETSTATWIDTH 17
#define REMOTESIZE 100 /* guaranteed to be enough */

#include <apollo/base.h>
#include <apollo/proc1.h>
#include <apollo/proc2.h>
#include <apollo/aclm.h>
#include <stdio.h>
#include <ctype.h>
#ifdef USE_SYSLOG
#include <syslog.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <strings.h>

extern char *calloc();
#if 0
void proc2_$upid_to_uid (int upid,    /* convert unix pid to puid */
                         uid_$t p2_uid,
                         status_$t *status
                        );
#endif
typedef struct {
  uid_$t pers;
  uid_$t proj;
  uid_$t org ;
  uid_$t subs;
  long   node;
  } acl_$sid;
void rgyc_$sid2text (acl_$sid *s, char *buffer, status_$t *st);

#define ZAP(x,err) if (x) if (flagauthd) \
{printf("%s, %s: ERROR: UNKNOWN-ERROR\r\n",localport,remoteport);exit(37);} \
else { fprintf(stderr,"%s: fatal: %s\n",argv[0],err); exit(37); }
/* Reporting errors honestly to a remote host could damage security. */

static char s[NETSTATBUF];
static char remote[REMOTESIZE];

struct UCB;
struct PCB;

struct	PCB
{
	struct PCB *self1;
	struct PCB *self2;
	struct PCB *next;
	struct PCB *prev;
	struct UCB *ucb;
} *sock_PCB;

#ifdef SR10_4
#define	DUMMY_LEN 0x4d
#else
#define DUMMY_LEN 0x46
#endif
struct	UCB
{
	struct UCB *next;
	struct UCB *prev;
	struct in_addr ucb_faddr;
	struct in_addr ucb_laddr;
	u_short ucb_fport;
	u_short ucb_lport;
	struct	PCB *pcb;
	void	*Unknown;
	char	Dummy[DUMMY_LEN];
	short	PID;
} *sock_UCB;

typedef struct proc2_$info_wsid
{
	proc2_$info_t	oldinfo;
        acl_$sid sid;           /* sid of process */
} proc2_$info_wsid;

main(argc,argv)
int argc;
char *argv[];
{
 FILE *fi;
 int fd;
 int pcb;
 int r1; int r2; int r3; int r4; int rp;
 int l1; int l2; int l3; int l4; int lp;
 int flagpwnam = 0;
 int flagauthd = 0;
 char localport[10];
 char remoteport[10];
 status_$t status;
 uid_$t Proc_UID;
 proc2_$info_wsid Proc_Info;
 char UserBuf[512];
 char *c;
 
 if ((!strcmp(argv[0],"authd"))
  || ((strlen(argv[0]) >= 6)
   && (!strcmp(argv[0] + strlen(argv[0]) - 6,"/authd"))))
   flagauthd = flagpwnam = 1;
 else
   if ((!strcmp(argv[0],"tcpuname"))
    || ((strlen(argv[0]) >= 9)
     && (!strcmp(argv[0] + strlen(argv[0]) - 9,"/tcpuname"))))
     flagpwnam = 1;

 if (flagauthd)
  {
   int ch;
   int localportlen;
   int remoteportlen;
   int loop;
   struct sockaddr_in sa;
   int salen;

   localportlen = remoteportlen = loop = 0;

   while ((ch = getchar()) != ',')
    {
     if (isascii(ch) && isdigit(ch)) localport[localportlen++] = ch;
     if (localportlen == 6) /* tough luck! */ exit(2);
     if ((++loop) > 1000) /* tough luck! */ exit(3);
    }
   while ((ch = getchar()) != '\n')
    {
     if (isascii(ch) && isdigit(ch)) remoteport[remoteportlen++] = ch;
     if (remoteportlen == 6) /* tough luck! */ exit(4);
     if ((++loop) > 1000) /* tough luck! */ exit(5);
    }

   localport[localportlen] = remoteport[remoteportlen] = 0;
   lp = atoi(localport);
   rp = atoi(remoteport);

   salen = sizeof(sa);
   if (getpeername(0,&sa,&salen) == -1)
    {
     printf("%s, %s: ERROR: UNKNOWN-ERROR\r\n",localport,remoteport);
     exit(6);
    }
   r1 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[0];
   r2 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[1];
   r3 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[2];
   r4 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[3];

   salen = sizeof(sa);
   if (getsockname(0,&sa,&salen) == -1)
    {
     printf("%s, %s: ERROR: UNKNOWN-ERROR\r\n",localport,remoteport);
     exit(6);
    }
   l1 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[0];
   l2 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[1];
   l3 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[2];
   l4 = (int) (unsigned int) ((unsigned char *) &sa.sin_addr)[3];
  }
 else
  {
   ZAP(argc < 4,"need four arguments")
   ZAP(sscanf(argv[1],"%d.%d.%d.%d",&r1,&r2,&r3,&r4)<4,"arg 1 must be a.b.c.d")
   ZAP(sscanf(argv[2],"%d",&rp) < 1,"arg 2 must be integer")
   ZAP(sscanf(argv[3],"%d.%d.%d.%d",&l1,&l2,&l3,&l4)<4,"arg 3 must be a.b.c.d")
   ZAP(sscanf(argv[4],"%d",&lp) < 1,"arg 4 must be integer")
  }

 (void) sprintf(remote,"%d.%d.%d.%d.%d                    ",r1,r2,r3,r4,rp);

#ifdef USE_SYSLOG
 /* This isn't worth the time for the procedure call, but if you want... */
 syslog(LOG_DEBUG,"authd: checking up on %d.%d.%d.%d %d %d.%d.%d.%d %d\n",
   r1,r2,r3,r4,rp,l1,l2,l3,l4,lp);
#endif

 fi = popen(NETSTAT,"r");
 ZAP(!fi,"cannot execute netstat")
 ZAP(!fgets(s,sizeof(s),fi),"cannot read netstat header line 1")
 ZAP(!fgets(s,sizeof(s),fi),"cannot read netstat header line 2")
 while (fgets(s,sizeof(s),fi))
  {
   ZAP(sscanf(s,"%8x",&pcb) != 1,"cannot scan netstat pcb address")
   sock_PCB = (struct PCB *) pcb;
   if (!strncmp(s + NETSTATREMOTE,remote,NETSTATWIDTH))
    {
     sock_UCB = sock_PCB->ucb;

     /* The following finds the user name given the PID.
      * thanks to szabo_p@maths.su.oz.au (Paul Szabo) for
      * information on how to do this, and no thanks to
      * Apollo for expecting the PID as the address of a
      * short whereas the Pascal would seem to imply it
      * to require an integer passed by value.
      */

     /* First convert the Unix PID to the Aegis UID */
     proc2_$upid_to_uid(&sock_UCB->PID, &Proc_UID, &status);
     ZAP((status.all != status_$ok), "Process no longer exists");

     /* Then find the SID for that process */
     proc2_$get_info(Proc_UID, (proc2_$info_t *) &Proc_Info,
		     sizeof(Proc_Info), &status);

     /* Convert the SID to text */
     memset(UserBuf, '\0', 512);
     rgyc_$sid2text(&Proc_Info.sid, UserBuf, &status);

     /* And discard the .group.org.subsystem section */
     if (c = index(UserBuf, '.'))
	*c++ = '\0';

     if (flagauthd)
     /* UNIX is a trademark of AT&T. :-)
      * It is questionable if this is really the right way to
      * behave. What if there are multiple account entries for the
      * same person? We probably shouldn't pretend to be UNIX
      * at all. Then again, some clients may use this to accept
      * root as "whatever you say, sir".
      */
       printf("%s, %s: USERID: UNIX: %s\r\n"
		    ,localport,remoteport,UserBuf);
      else
	printf("%s\n",UserBuf);
      exit(0);
     }
  }
 ZAP(1,"no such TCP connection")
 exit(1);
}
