(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Ceiling.m3                                            *)
(* Last Modified On Tue Jun 30 08:50:57 PDT 1992 By kalsow     *)
(*      Modified On Sat Dec  8 00:54:26 1990 By muller         *)

MODULE Ceiling;

IMPORT CallExpr, Expr, Type, Procedure, Int, Reel, LReel, EReel;
IMPORT Emit, Error, ReelExpr, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  BEGIN
    DoCheck ("CEILING", args);
    RETURN Int.T;
  END Check;

PROCEDURE DoCheck (name: TEXT; args: Expr.List) =
  VAR t: Type.T;
  BEGIN
    t := Type.Base (Expr.TypeOf (args[0]));
    IF (t # Reel.T) AND (t # LReel.T) AND (t # EReel.T) THEN
      Error.ID (name, "wrong argument type");
    END;
  END DoCheck;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Temp.AllocEmpty (Int.T);
    Emit.OpTT ("@ = _CEILING (@);\n", t2, t1);
    Temp.Free (t1);
    RETURN t2;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR e, x: Expr.T;
  BEGIN
    e := Expr.ConstValue (args[0]);
    IF    (e = NIL)                THEN RETURN NIL;
    ELSIF ReelExpr.Ceiling (e, x)  THEN RETURN x;
    ELSE  (* bogus *)                   RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("CEILING", Z, TRUE);
  END Initialize;

BEGIN
END Ceiling.
