(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: LReel.m3                                              *)
(* Last Modified On Mon Mar  2 10:33:10 PST 1992 by kalsow     *)
(*      Modified On Wed Sep 26 18:57:30 1990 by muller         *)

MODULE LReel;

IMPORT Type, Target, Tipe, Emit, MBuf, TypeRep;

TYPE
  P = Type.T BRANDED "LReel.T" OBJECT
      OVERRIDES
      (*check      := ALREADY DONE *)
        base       := TypeRep.SelfBase;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        count      := TypeRep.NotOrdinal;
        bounds     := TypeRep.NotBounded; 
        size       := Sizer;
        minSize    := Sizer;
        alignment  := Aligner;
	isEmpty    := TypeRep.IsNever;
        dependsOn  := TypeRep.DependsOnNone;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := GenInit;
        mapper     := TypeRep.NoMapper;
        fprint     := FPrinter;
        class      := MyClass;
      END;

PROCEDURE MyClass (<*UNUSED*> t: Type.T): TypeRep.Class =
  BEGIN
    RETURN TypeRep.Class.None;
  END MyClass;

PROCEDURE Sizer (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN Target.LONGREALSIZE;
  END Sizer;

PROCEDURE Aligner (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN Target.LONGREALALIGN;
  END Aligner;

PROCEDURE Compiler (t: Type.T) =
  BEGIN
    Emit.OpF ("\003#define @ _LONGREAL\n", t);
    IF TypeRep.StartLinkInfo (t) THEN RETURN END;
    Emit.Op  ("C\n");
    Emit.OpF ("\003#define @ _LONGREAL\n", t);
    Emit.Op  ("*\n");
  END Compiler;

PROCEDURE InitCoster (<*UNUSED*> t: Type.T; zeroed: BOOLEAN): INTEGER =
  BEGIN
    (* not every bit pattern is a legal LONGREAL *)
    IF zeroed THEN RETURN 0 ELSE RETURN 1 END;
  END InitCoster;

PROCEDURE GenInit (<*UNUSED*> t: Type.T) =
  BEGIN
    Emit.Op ("0.0");
  END GenInit;

PROCEDURE FPrinter (<*UNUSED*>t: Type.T; <*UNUSED*>map: Type.FPMap; wr: MBuf.T) =
  BEGIN
    MBuf.PutText (wr, "$longreal");
  END FPrinter;

PROCEDURE Initialize () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T);
    T.checked := TRUE;
    T.hash := 2;
    Tipe.Define ("LONGREAL", T, TRUE);
  END Initialize;

BEGIN
END LReel.
