(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ProcExpr.m3                                           *)
(* Last modified on Tue Sep 22 12:25:11 PDT 1992 by kalsow     *)
(*      modified on Tue Oct 10 18:42:24 1989 by muller         *)

MODULE ProcExpr;

IMPORT Expr, ExprRep, Type, Value, Temp, MBuf, Emit, Procedure;

TYPE
  P = Expr.T OBJECT
        proc : Value.T;
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        compile      := Compile;
        evaluate     := ExprRep.Self;
        fprint       := FPrinter;
        write        := ExprRep.NoWriter;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	note_write   := ExprRep.NotWritable;
	genLiteral   := GenLiteral;
      END;

PROCEDURE New (proc: Value.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.proc := Value.Base (proc);
    RETURN p;
  END New;

PROCEDURE Split (e: Expr.T;  VAR proc: Value.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL => RETURN FALSE;
    | P(p) => proc := p.proc; RETURN TRUE;
    ELSE      RETURN FALSE;
    END;
  END Split;

PROCEDURE Compare (a, b: Expr.T;  VAR sign: INTEGER): BOOLEAN =
  VAR x, y: Value.T;
  BEGIN
    TYPECASE a OF
    | NULL => RETURN FALSE;
    | P(p) => x := p.proc;
    ELSE      RETURN FALSE;
    END;
    TYPECASE b OF
    | NULL => RETURN FALSE;
    | P(p) => y := p.proc;
    ELSE      RETURN FALSE;
    END;
    IF (x = y) THEN sign := 0 ELSE sign :=  -3 END;
    RETURN TRUE;
  END Compare;

PROCEDURE TypeOf (p: P): Type.T =
  BEGIN
    RETURN Value.TypeOf (p.proc);
  END TypeOf;

PROCEDURE Check (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Value.TypeCheck (p.proc, cs);
    p.type := Value.TypeOf (p.proc);
  END Check;

PROCEDURE EqCheck (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL => RETURN FALSE;
    | P(b) => RETURN Procedure.IsEqual (a.proc, b.proc);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE Compile (p: P): Temp.T =
  BEGIN
    RETURN Value.Load (p.proc);
  END Compile;

PROCEDURE FPrinter (p: P;  map: Type.FPMap;  wr: MBuf.T) =
  BEGIN
    Value.Fingerprint (p.proc, map, wr)
  END FPrinter;

PROCEDURE GenLiteral (p: P) =
  BEGIN
    Emit.OpN ("@", p.proc);
  END GenLiteral;

BEGIN
END ProcExpr.
