(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Marker.i3                                             *)
(* Last Modified On Wed Apr 15 09:46:34 PDT 1992 by kalsow     *)
(*      Modified On Sat Jun 10 18:44:15 PDT 1989 by muller     *)

INTERFACE Marker;

IMPORT Type, Variable, Temp;

TYPE
  Label  = INTEGER;

PROCEDURE Pop ();

(* TRY-EXCEPT *)
PROCEDURE PushTry     (x: Label);
PROCEDURE PushTryElse (x: Label);
(**PROCEDURE EmitReraise (x: Label);**)

(* TRY-FINALLY *)
PROCEDURE PushFinallyProc (x: Label);
PROCEDURE PushFinally (x: Label);
PROCEDURE PopFinally  (VAR(*OUT*) returnSeen, exitSeen: BOOLEAN);

(* LOCK-END *)
PROCEDURE PushLock (x: Label);

(* LOOP-EXIT *)
PROCEDURE PushExit (x: Label);
PROCEDURE ExitOK   (): BOOLEAN;
PROCEDURE EmitExit ();

(* TRY-PASSING (RAISES) *)
PROCEDURE PushRaises (x: Label);

(* PROCEDURE-RETURN *)
PROCEDURE PushProcedure (t: Type.T;  v: Variable.T);
PROCEDURE ReturnVar     (VAR(*OUT*) t: Type.T;  VAR(*OUT*) v: Variable.T);
PROCEDURE ReturnOK      (): BOOLEAN;
PROCEDURE EmitReturn    (val: Temp.T;  type: Type.T);

PROCEDURE Reset ();

END Marker.
