(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Wed Jun  3 16:22:52 PDT 1992 by muller                   *)

MODULE RTSignal;

IMPORT RTMisc, Usignal;
FROM Ctypes IMPORT int;

PROCEDURE InstallHandlers () =
  VAR sv, osv: Usignal.struct_sigvec;  i: int;
  BEGIN
    sv.sv_handler := PossibleNilDereference;
    sv.sv_mask    := Usignal.empty_sv_mask;
    sv.sv_flags   := 0;
    i := Usignal.sigvec (Usignal.SIGSEGV, sv, osv);
    <* ASSERT  i = 0 *>

    sv.sv_handler := PossibleStackOverflow;
    sv.sv_mask    := Usignal.empty_sv_mask;
    sv.sv_flags   := 0;
    i := Usignal.sigvec (Usignal.SIGBUS, sv, osv);
    <* ASSERT  i = 0 *>

    sv.sv_handler := NIL;
    sv.sv_mask    := Usignal.empty_sv_mask;
    sv.sv_flags   := 0;
    i := Usignal.sigvec (Usignal.SIGQUIT, sv, osv);
    <* ASSERT  i = 0 *>
  END InstallHandlers;

PROCEDURE PossibleNilDereference (<*UNUSED*> sig, code: int; 
            <*UNUSED*> scp: UNTRACED REF Usignal.struct_sigcontext) =
  VAR pc := 0;
  BEGIN
    (*IF (scp # NIL) THEN pc := scp.sc_pc END;*)
    RTMisc.FatalErrorPC (pc,
      "Segmentation violation - possible attempt to dereference NIL");
  END PossibleNilDereference;

PROCEDURE PossibleStackOverflow (<*UNUSED*> sig, code: int; 
              <*UNUSED*> scp: UNTRACED REF Usignal.struct_sigcontext) =
  VAR pc := 0;
  BEGIN
    (*IF (scp # NIL) THEN pc := scp.sc_pc END;*)
    RTMisc.FatalErrorPC (pc,
      "Bus error - possible thread stack overflow");
  END PossibleStackOverflow;

BEGIN
END RTSignal.
