(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Apr 23 09:25:38 PDT 1992 by kalsow     *)
(*      modified on Tue Jun 25 10:54:37 1991 by muller         *)

MODULE NullWr;

IMPORT Wr, WrClass;

CONST
  BuffSize = 1024;

REVEAL
  T = Wr.T BRANDED OBJECT
           OVERRIDES
             seek  := Seek;
             flush := Flush;
	     close := Close;
           END;

EXCEPTION Error;
<*FATAL Error*>

PROCEDURE New (): T RAISES {} =
  BEGIN
    RETURN (NEW (T,
		    st := 0,
		    lo := 0,
		    cur := 0,
		    hi := BuffSize,
	            buff := NEW (REF ARRAY OF CHAR, BuffSize),
		    closed := FALSE,
		    seekable := FALSE,
		    buffered := TRUE));
  END New;

PROCEDURE Seek (wr: T; n: CARDINAL) RAISES {} =
  BEGIN
    IF (n # wr.cur) OR (wr.cur # wr.hi) THEN RAISE Error(*Unseekable*); END;
    wr.lo := wr.cur;
    wr.hi := wr.cur + 1;
  END Seek;

PROCEDURE Flush (<*UNUSED*> wr: T) RAISES {} =
  BEGIN
  END Flush;

PROCEDURE Close (wr: T) RAISES {} =
  BEGIN
    wr.buff := NIL;
    wr.closed := TRUE;
  END Close;

BEGIN
END NullWr.
