(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 16:18:30 PST 1992 by muller                   *)

MODULE Pathname;

IMPORT Text;

PROCEDURE Dir (path: Text.T): Text.T = 
  BEGIN
    WITH slash = Text.FindCharR (path, '/') DO
      RETURN Text.Sub (path, 0, slash + 1); END;
  END Dir;

PROCEDURE FindSlashAndDot (path: Text.T; VAR slash, dot: INTEGER) =
  BEGIN
    slash := Text.FindCharR (path, '/');
    dot := Text.FindCharR (path, '.') ;
    IF dot <= slash + 1
         OR dot = Text.Length (path) - 1
         OR Text.GetChar (path, dot - 1) = '.' THEN
       dot := -1; END;
  END FindSlashAndDot;

PROCEDURE Name (path: Text.T): Text.T =
  VAR slash, dot: INTEGER;
  BEGIN
    FindSlashAndDot (path, slash, dot);
    IF dot = -1 THEN 
      RETURN Text.Sub (path, slash + 1, LAST (INTEGER));
    ELSE
      RETURN Text.Sub (path, slash + 1, dot - slash - 1); END;
  END Name;

PROCEDURE Sep (path: Text.T): Text.T =
  VAR slash, dot: INTEGER;
  BEGIN
    FindSlashAndDot (path, slash, dot);
    IF dot = -1 THEN
      RETURN "";
    ELSE
      RETURN "."; END;
  END Sep;


PROCEDURE Ext (path: Text.T): Text.T =
  VAR slash, dot: INTEGER;
  BEGIN
    FindSlashAndDot (path, slash, dot);
    IF dot = -1 THEN
      RETURN "";
    ELSE 
      RETURN Text.Sub (path, dot + 1, LAST (INTEGER)); END;
  END Ext;

PROCEDURE Make (dir, name, ext: Text.T): Text.T =
  BEGIN
    WITH n = Text.Length (dir) DO
      IF n > 0 AND Text.GetChar (dir, n - 1) # '/' THEN
        dir := dir & "/"; END; END;
    IF Text.Length (ext) = 0 THEN
      RETURN (dir & name);
    ELSE
      RETURN (dir & name & "." & ext); END;
  END Make;

BEGIN
END Pathname.
