(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Wed Oct 28 17:00:07 MET 1992 by preschern *)
(*      modified on Fri Mar 16 12:16:52 1990 by muller        *)

UNSAFE MODULE Usignal;

IMPORT Word;
FROM Ctypes IMPORT int;

PROCEDURE sigmask (n: INTEGER): INTEGER =
BEGIN
  RETURN Word.Shift (1, n-1);
END sigmask;

PROCEDURE sigvec (sig: int; VAR vec, ovec: struct_sigvec): int =
  BEGIN
    (* should be <* ASSERT FALSE *> but this breaks
     * therefore we close our eyes and run it with fingers crossed
     *) 
    RETURN 0;
  END sigvec; 

BEGIN
  BADSIG  := LOOPHOLE (-1, SignalHandler);
  SIG_ERR := LOOPHOLE (-1, SignalHandler);
  SIG_DFL := LOOPHOLE ( 0, SignalHandler);
  SIG_IGN := LOOPHOLE ( 1, SignalHandler);
END Usignal.
