#include <sys/file.h>
#include <stdio.h>
#include "config.h"

extern char *sys_errlist[];
extern int errno;
extern char *getpass();
extern char *crypt();
extern char *index();
extern char *ttyname();

#define IN 1
#define OUT 0

#ifdef LOG_FILE
void log(which, name, host, tty)
int which;
char *name,
    *tty,
    *host;
{
    FILE *fp;
    long t;

    if (access(LOG_FILE,F_OK))
	return;
    if (fp = fopen(LOG_FILE, "a")) {
	t = time(0);
	if (which) {
	    if (name)
		fprintf(fp, "%s by %s@%s on %s at %.16s\n", which ? "Login" : "Logout", name, host, tty + 5, ctime(&t));
	    else
		fprintf(fp, "%s by %s on %s at %.16s\n", which ? "Login" : "Logout", host, tty + 5, ctime(&t));
	} else
	    fprintf(fp, "Connection closed from %s on %s at %.16s\n", host, tty + 5, ctime(&t));
	fclose(fp);
    }
}
#endif LOG_FILE

#ifdef PASSWD_FILE
#ifdef USE_LOG
void log_use(name)
char *name;
{
    FILE *fp;
    long pos;
    int len,
        cnt = 0;
    char buffer[BUFSIZ + 1];

    if (access(USE_LOG,F_OK))
	return;
    if (fp = fopen(USE_LOG, "r+")) {
	pos = 0L;
	len = strlen(name);
	while (fgets(buffer, BUFSIZ, fp)) {
	    if (strncmp(buffer, name, len) == 0) {
		char *ptr;

		if (ptr = index(buffer, ' ')) {
		    cnt = atoi(ptr + 1);
		    fseek(fp, pos, 0);
		    break;
		}
	    }
	    pos = ftell(fp);
	}
	fprintf(fp, "%-9s %8d\n", name, cnt + 1);
	fclose(fp);
    }
}
#endif USE_LOG

struct passwd {			/* see getpwent(3) */
    char *pw_name;
    char *pw_passwd;
    int pw_uid;
    int pw_gid;
    int pw_quota;
    char *pw_comment;
    char *pw_gecos;
    char *pw_dir;
    char *pw_shell;
};

static char passwd_file[BUFSIZ + 1];
static char new_passwd_file[BUFSIZ + 1];

static void setpwfile(name)
char *name;
{
    strncpy(passwd_file, name, BUFSIZ);
    strncpy(new_passwd_file, name, BUFSIZ);
    strcat(new_passwd_file, ".new");
}

static struct passwd *getpwnam(name)
char *name;
{
    FILE *fp;
    static char buffer[BUFSIZ + 1];
    char *ptr,
        *word;
    static struct passwd entry;

    if ((fp = fopen(passwd_file, "r")) == NULL)
	return (NULL);
    while (fgets(buffer, BUFSIZ, fp)) {
	*(buffer + strlen(buffer) - 1) = '\0';
	word = buffer;
	ptr = index(word, ':');
	*(ptr++) = NULL;
	if (strcmp(word, name) == 0) {
	    entry.pw_name = word;
	    word = ptr;
	    ptr = index(word, ':');
	    *(ptr++) = NULL;
	    entry.pw_passwd = word;

	    word = ptr;
	    ptr = index(word, ':');
	    *(ptr++) = NULL;
	    entry.pw_uid = atoi(word);

	    entry.pw_gecos = ptr;
	    return (&entry);
	}
    }
    return (NULL);
}

/* chpwd: changes the password for the user with name username to passwd */
void chpwd(username, passwd)
char *username,
    *passwd;
{
    int len;
    FILE *pwd,
        *pwd_new;
    char line[BUFSIZ + 1],
         new_line[BUFSIZ + 1],
        *ptr;

    if ((pwd = fopen(passwd_file, "r")) == NULL) {
	netwrite("Couldn't open password file!\nPassword change failed!");
	return;
    }
    if ((pwd_new = fopen(new_passwd_file, "w")) == NULL) {
	netwrite("Couldn't write new new password file1\nPassword change failed!");
	fclose(pwd);
	return;
    }
    fchmod(fileno(pwd_new), 0644);
    strcat(username, ":");
    len = strlen(username);
    while (fgets(line, BUFSIZ, pwd)) {
	if (strncmp(username, line, len) == 0) {
	    ptr = index(line + len, ':');
	    sprintf(new_line, "%s%s%s", username, passwd, ptr);
	    fputs(new_line, pwd_new);
	    break;
	} else
	    fputs(line, pwd_new);
    }
    while (fgets(line, BUFSIZ, pwd))
	fputs(line, pwd_new);
    fclose(pwd);
    fclose(pwd_new);
    if (rename(new_passwd_file, passwd_file)) {
	netwrite("Error while updating password file!\nPassword change failed!");
	return;
    }
    chmod(passwd_file, 0644);
    netwrite("Password change successful\n");
}

int login(name)
char *name;
{
    char *pass,
        *enc,
         salt[3];
    struct passwd *entry;

    pass = getpass("Password:");
    setpwfile(PASSWD_FILE);
    if (entry = getpwnam(name)) {
	if (strlen(entry->pw_passwd)) {
	    salt[0] = entry->pw_passwd[0];
	    salt[1] = entry->pw_passwd[1];
	    salt[2] = NULL;
	    enc = crypt(pass, salt);
	    return (strcmp(enc, entry->pw_passwd) == 0);
	} else
	    return (1);
    } else
	return (0);
}

void change_password(username)
char *username;
{
    struct passwd *pwent;
    char entered_passwd[14],
         salt[3];

    setpwfile(PASSWD_FILE);
    pwent = getpwnam(username);
    sprintf(salt, "%02x", pwent->pw_uid);
    strcpy(entered_passwd, crypt(getpass("Old password: "), salt));
    if ((*pwent->pw_passwd == '\0') || (strcmp(entered_passwd, pwent->pw_passwd) == 0)) {
	strcpy(entered_passwd, crypt(getpass("New Password: "), salt));
	if (strcmp(entered_passwd, crypt(getpass("Repeat: "), salt)) == 0) {
	    chpwd(pwent->pw_name, entered_passwd);
	    return;
	}
    }
    netwrite("Incorrect Password!\n");
}
#endif PASSWD_FILE

void motd(file)
char *file;
{
    FILE *fp;
    char buffer[BUFSIZ + 1];

    if (fp = fopen(file, "r")) {
	while (fgets(buffer, BUFSIZ, fp))
	    netwrite(buffer);
	fclose(fp);
    }
}


void start_irc(nick, name, file)
char *nick,
    *name,
    *file;
{
    char *envinit[10];
    char *args[10];
    char ircname[BUFSIZ + 1];
    char nickname[BUFSIZ + 1];
    char term[BUFSIZ + 1];
    char c;

    sprintf(ircname, "IRCNAME=%s", name);
    envinit[0] = ircname;

    sprintf(nickname, "IRCNICK=%s", nick);
    envinit[1] = nickname;

    strcpy(term, "TERM=");
    netwrite("Enter Terminal Type or just hit return for no terminal type: ");
    fgets(term + 5, BUFSIZ - 5, stdin);
    c = *(term + strlen(term) - 1);
    if ((c == '\n') || (c == '\r'))
	*(term + strlen(term) - 1) = 0;
    c = *(term + strlen(term) - 1);
    if ((c == '\n') || (c == '\r'))
	*(term + strlen(term) - 1) = 0;
    envinit[2] = term;

#ifdef IRCSERVER
    envinit[3] = IRCSERVER;
    envinit[4] = NULL;
#else
    envinit[3] = NULL;
#endif

    setuid(DAEMON_UID);
    c = 0;
    args[c++] = "irc";
    if (strcmp(term, "TERM=") == 0)
	args[c++] = "-d";
    if (file) {
	args[c++] = "-l";
	args[c++] = file;
    }
    args[c++] = NULL;

    execve(IRCII_PATH, args, envinit);
    sprintf(term, "Unable to start IRCII at this time: %s.\n", sys_errlist[errno]);
    netwrite(term);
    exit(1);
}

void irc_loop(host)
char *host;
{
    char name[BUFSIZ + 1],
         choice[BUFSIZ + 1],
         c;
    struct passwd *entry;

#ifdef BANNER_FILE
    motd(BANNER_FILE);
#endif BANNER_FILE
#ifdef PASSWD_FILE
    while (1) {
	netwrite("Nickname: ");
	if (fgets(name, BUFSIZ, stdin) == NULL)
	    return;
	c = *(name + strlen(name) - 1);
	if ((c == '\n') || (c == '\r'))
	    *(name + strlen(name) - 1) = 0;
	c = *(name + strlen(name) - 1);
	if ((c == '\n') || (c == '\r'))
	    *(name + strlen(name) - 1) = 0;

	if (*name) {
	    if (login(name)) {
#ifdef LOG_FILE
		log(1, name, host, ttyname(0));
#endif LOG_FILE
#ifdef USE_LOG
		log_use(name);
#endif USE_LOG
#ifdef MOTD_FILE
		motd(MOTD_FILE);
#endif MOTD_FILE
		while (1) {
		    netwrite("Choose one of the following:\n0) Start IRCII\n1) Change Password\n2) Close connection.\n\nChoice: ");
		    if (fgets(choice, BUFSIZ, stdin) == NULL)
			return;
		    switch (atoi(choice)) {
			case 1:
			    change_password(name);
			    break;
			case 2:
			    return;
			default:
			    entry = getpwnam(name);
#ifdef SAVE_DIR
			    sprintf(choice, "%s/irc.%s", SAVE_DIR, entry->pw_name);
			    start_irc(name, entry->pw_gecos, choice);
#else
			    start_irc(name, entry->pw_gecos, NULL);
#endif SAVE_DIR
			    break;
		    }
		}
	    } else
		netwrite("Login incorrect\n");
	}
    }
#else PASSWD_FILE
    while (1) {
	netwrite("Nickname: ");
	if (fgets(name, BUFSIZ, stdin) == NULL)
	    return;
	c = *(name + strlen(name) - 1);
	if ((c == '\n') || (c == '\r'))
	    *(name + strlen(name) - 1) = 0;
	c = *(name + strlen(name) - 1);
	if ((c == '\n') || (c == '\r'))
	    *(name + strlen(name) - 1) = 0;

	if (*name) {
#ifdef LOG_FILE
	    log(1, name, host, ttyname(0));
#endif LOG_FILE
	    start_irc(name, host, NULL);
	}
    }
#endif PASSWD_FILE
}
