/*
 * sic.c: testing...
 *
 * Copyright(c) 1997,1998,1999 - All Rights Reserved
 *
 * See the COPYRIGHT file.
 */

#ifndef lint
static char rcsid[] = "@(#)$Id: sic.c,v 1.13 1999/01/02 22:14:19 kalt Exp $";
#endif

#include "os.h"

#include "struct.h"
#include "window.h"
#include "server.h"
#include "input.h"
#include "term.h"
#include "option.h"
#include "config.h"
#include "counter.h"

extern const char version[];

void
main (argc, argv)
  int argc;
  char *argv[];
{
  int o;
  char doconn = 1, err = 0, newenv[256];
  time_t now, next_dlog = time(NULL) + 600, next_counter = time(NULL) + 60;

  extern char *optarg;
  extern int opterr;

  opterr = 0;
  while ((o = getopt(argc, argv, "c:i:l:nv")) != EOF)
      switch (o) {
    case 'c':
	sprintf(newenv, "SICDIR=%s", optarg);
	putenv(newenv);
	break;
    case 'i':
	sprintf(newenv, "SICIP=%s", optarg);
	putenv(newenv);
	break;
    case 'l':
	sprintf(newenv, "SICLOG=%s", optarg);
	putenv(newenv);
	break;
    case 'n':
	doconn = 0;
	break;
    case 'v':
	printf("sic %s, Copyright (C) 1997,1998,1999 Christophe Kalt <kalt@stealth.net>\n", version);
#if defined(USE_GNU_RX)
	printf("\tLinked with %s\n", rx_version_string);
#endif
	exit(0);
    default:
	err++;
	break;
      }
  if (err)
    {
      printf("sic [-c <config>] [-i <IP address>] [-l <logdir>] [-n] [-v]\n");
      printf("\t-c\tDefine the directory where configuration files live\n");
      printf("\t-i\tUse a specific IP address for connections\n");
      printf("\t-l\tDefine the directory where log files go\n");
      printf("\t-n\tDon't auto-connect upon start.\n");
      printf("\t-v\tPrint version and exits\n\n");
      exit(0);
    }

  /* no window/lastlog ability */
  /* dns_init(); */
  opt_init();
  counter_init();
  /* initialize window/lastlog */
  term_init();
  sic_newwin();
  /* window/lastlog initialized */
  cfg_init(); /* error messages will be in the lastlog */
  opt_cfg();

  if (doconn)
      cmd_server("0"); /* connect! */

  while (1)
    {
      if (sic_select() > 0)
	sic_getch();

      now = time(NULL);
      if (now > next_dlog)
	{
	  next_dlog = now + 900;
	  sic_dlog(0);
	}
#if defined(HAVE_REGEXP)
      if (now > next_counter)
	{
	  next_counter = now + 60;
	  counter_expire(-1);
	}
#endif
    }
  /* we can never get here anymore.. */
  term_end();
  exit(0);
}
