# Before 'make install' is performed this script should be runnable with
# 'make test'. After 'make install' it should work as 'perl Minecraft-NBTReader.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use strict;
use warnings;

use Test::More;
BEGIN { use_ok('Minecraft::NBTReader') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $sixtyfourbit = 0;
eval {
    my $foo = pack('q', 1);
    $sixtyfourbit = 1;
};

ok($sixtyfourbit, "pack() does not support 64bit quads!");
if(!$sixtyfourbit) {
    done_testing();
    exit;
}

ok(-f 't/bigtest.nbt', 'Found bigtest.nbt');
if(!-f 't/bigtest.nbt') {
    done_testing();
    exit;
}

my $reader = Minecraft::NBTReader->new();
ok(defined($reader), "new()");

my $evalok = 0;
my %data;
#eval {
    %data = $reader->readFile('t/bigtest.nbt');
    $evalok = 1;
#};

ok($evalok, 'Load file without crashing');
exit(0) unless($evalok);
ok(defined($data{'Level'}), 'Root TAG_Compound loaded');

ok($data{'Level'}->{'byteTest'} == 127, "byteTest");
ok($data{'Level'}->{'shortTest'} == 32767, "shortTest");
ok($data{'Level'}->{'intTest'} == 2147483647, "intTest");
ok($data{'Level'}->{'longTest'} == 9223372036854775807, "longTest");
ok($data{'Level'}->{'stringTest'} eq 'HELLO WORLD THIS IS A TEST STRING ÅÄÖ!', "stringTest (this may fail due to Unicode stuff)");

# Test float & double only aproxximately due to rounding-error-by-design
ok(int($data{'Level'}->{'floatTest'} * 10000) == 4982, "floatTest");
ok(int($data{'Level'}->{'doubleTest'} * 1000000) == 493128, "doubleTest");

ok($data{'Level'}->{'nested compound test'}->{'ham'}->{'name'} eq 'Hampus', "nested compound/ham/name");
ok($data{'Level'}->{'nested compound test'}->{'ham'}->{'value'} eq 0.75, "nested compound/ham/value");
ok($data{'Level'}->{'nested compound test'}->{'egg'}->{'name'} eq 'Eggbert', "nested compound/egg/name");
ok($data{'Level'}->{'nested compound test'}->{'egg'}->{'value'} eq 0.5, "nested compound/egg/value");

for(my $i = 0; $i < 5; $i++) {
    ok(defined($data{'Level'}->{'listTest (long)'}->[$i]), "ListTest (long) element $i defined");
    ok($data{'Level'}->{'listTest (long)'}->[$i] == ($i + 11), "ListTest (long) element $i correct");
}


for(my $i = 0; $i < 2; $i++) {
    ok(defined($data{'Level'}->{'listTest (compound)'}->[$i]->{'created-on'}), "ListTest (compound) element $i/created-on defined");
    ok(defined($data{'Level'}->{'listTest (compound)'}->[$i]->{'name'}), "ListTest (compound) element $i/name defined");
    ok($data{'Level'}->{'listTest (compound)'}->[$i]->{'created-on'} eq '1264099775885', "ListTest (compound) element $i/created-on correct");
    ok($data{'Level'}->{'listTest (compound)'}->[$i]->{'name'} eq "Compound tag #$i", "ListTest (compound) element $i/name correct");
}

# The formula given my Notch for the TAG_Byte_Array test is incorrect, so just use a known data dump of the numbers
# (if n==0 then any multiplication with it is also 0, which means the addition of 2 such multiplication products is 0)
my $keyname = 'byteArrayTest (the first 1000 values of (n*n*255+n*7)%100, starting with n=0 (0, 62, 34, 16, 8, ...))';
ok(defined($data{'Level'}->{$keyname}), 'byteArrayTest defined');
my @knowngood = (0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86,
 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22,
 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50,
 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64,
 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32,
 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58,
 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74,
 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80,
 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76,
 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84,
 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90,
 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78,
 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94,
 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62,
 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88,
 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36,
 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44,
 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0,
 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22, 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88,
 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98, 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54,
 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64, 46, 38, 40, 52, 74, 6, 48, 0, 62, 34, 16, 8, 10, 22,
 44, 76, 18, 70, 32, 4, 86, 78, 80, 92, 14, 46, 88, 40, 2, 74, 56, 48, 50, 62, 84, 16, 58, 10, 72, 44, 26, 18, 20, 32, 54, 86, 28, 80, 42, 14, 96, 88, 90, 2, 24, 56, 98,
 50, 12, 84, 66, 58, 60, 72, 94, 26, 68, 20, 82, 54, 36, 28, 30, 42, 64, 96, 38, 90, 52, 24, 6, 98, 0, 12, 34, 66, 8, 60, 22, 94, 76, 68, 70, 82, 4, 36, 78, 30, 92, 64,
 46, 38, 40, 52, 74, 6, 48);

for(my $i = 0; $i < 1000; $i++) {
    my $n = $knowngood[$i];
    ok(defined($data{'Level'}->{$keyname}->[$i]), "byteArrayTest element $i defined");
    ok($data{'Level'}->{$keyname}->[$i] == $n, "byteArrayTest element $i correct");
}

done_testing();
