#!/usr/bin/env raku

use Terminal::ANSI;

save-screen;
clear-screen;
home;

hide-cursor;

sub scroll($row,$col = 1, $height = 7) {
  print-at $row,$col, "━" x 20;
  print-at $row + $height,$col, "━" x 20;
  my $on = $row;
  set-scroll-region($row + 1,$row + $height - 1);
  for 200, 199 ... 0 {
    scroll-up if $on >= $row + $height - 1;
    print-at ++$on min $row + $height - 1, $col, "counting down..$_";
  }
  reset-scroll-region;
}

scroll(2);
sleep 1;

show-cursor;
restore-screen;
